#include <QDebug>

#include <QObject>

#include "mapwidget.h"

#if (QTM_VERSION >= 0x010200)

MapOverlay::MapOverlay(MapWidget *mapWidget) : QGeoMapOverlay() {
  int step = 80;

  qDebug() << __FUNCTION__;

  // create a buttonmanager and fill with buttons
  m_mapButtonManager = new MapButtonManager(64);

  MapButton *zoom_in = m_mapButtonManager->create("zoom_in", 16, 16);
  QObject::connect(zoom_in, SIGNAL(clicked()), mapWidget, SLOT(zoomIn()));

  MapButton *gps = m_mapButtonManager->create("gps", 16, 16+step, MapButton::Disabled);
  QObject::connect(gps, SIGNAL(clicked()), mapWidget, SLOT(gpsFollow()));

  MapButton *zoom_out = m_mapButtonManager->create("zoom_out", 16, 16+2*step);
  QObject::connect(zoom_out, SIGNAL(clicked()), mapWidget, SLOT(zoomOut()));
};

MapOverlay::~MapOverlay() {
  qDebug() << __FUNCTION__;

  delete m_mapButtonManager;
};

void MapOverlay::enableZoomButtons(bool in, bool out) {
  m_mapButtonManager->setState("zoom_in", in?MapButton::Normal:MapButton::Disabled);
  m_mapButtonManager->setState("zoom_out", out?MapButton::Normal:MapButton::Disabled);
}

void MapOverlay::enableGpsButton(bool on) {
  m_mapButtonManager->setState("gps", on?MapButton::Normal:MapButton::Disabled);
}

void MapOverlay::changeGpsButton(bool locked) {
  m_mapButtonManager->change("gps", locked?"gps_follow":"gps");
}

void MapOverlay::paint(QPainter *painter, 
		       const QStyleOptionGraphicsItem *) {
  m_mapButtonManager->paint(painter);
};

bool MapOverlay::mousePress(const QPointF &p) {
  return m_mapButtonManager->mousePress(p);
}

bool MapOverlay::mouseMove(const QPointF &p) {
  return m_mapButtonManager->mouseMove(p);
}

bool MapOverlay::mouseRelease(const QPointF &p) {
  return m_mapButtonManager->mouseRelease(p);
}

bool MapOverlay::isInside(const QPointF &p) {
  return m_mapButtonManager->isInside(p);
}

#endif
