// gcprovider.h
#ifndef GCPROVIDER_H
#define GCPROVIDER_H

#include <QtNetwork>
#include "cacheprovider.h"

class GcProvider : public CacheProvider {
  Q_OBJECT;
  
 public:
  GcProvider();
  ~GcProvider();
  virtual QString name();
  virtual bool initialized();
  virtual void processRequestOverview(const QGeoBoundingBox &);
  virtual void processRequestInfo(const QString &);
  virtual void requestDetail(const QString &);

 public slots:
  void replyFinished(QNetworkReply*);

 private:
  void requestUserToken();
  QString subString(QString &, const QString &, const QString &);
  bool decodeUserToken(const QByteArray&);
  void postJson(const QString &);

  QNetworkAccessManager *m_manager;
  QString m_userToken;
  bool m_initialized;
  bool m_bigArea;
  CacheList m_cacheList;
  Cache m_cache;
};

#endif // GCPROVIDER_H
