#include <stdlib.h> 
#include <glib.h>

#include "dictionary.h"

GPtrArray *dictionary;
gint indexes[];

void dict_prepare(){
  dictionary = g_ptr_array_new();
  dict_load_from_file();
}

gint dict_size() {
  return dictionary->len;
}

void dict_add(gchar *word) {
  g_ptr_array_add(dictionary, (gpointer)word);
}

void dict_remove(gchar *word) {
  gint i = 0;
  for (i; i < dictionary->len; ++i){
    if(g_strcmp0((gchar*)g_ptr_array_index(dictionary,i), word) == 0)
      g_ptr_array_remove_index (dictionary, i); 
  }
}

gchar *dict_get_mixed(int i) {
  return (char*)g_ptr_array_index(dictionary, indexes[i]);
}

gchar *dict_get(int i){
  return (char*)g_ptr_array_index(dictionary, i);
}

void dict_order(){
  g_ptr_array_sort(dictionary, (GCompareFunc)compare_strings);
}

void dict_mix() {
  gint i = 0;
  
  for(i; i < dict_size(); ++i) {
    indexes[i] = i;
  }

  gint swap_with, tmp_index = 0;
  GRand *rand = g_rand_new();
  
  for(i=0; i < dict_size(); ++i) {
    swap_with = g_rand_int_range(rand,0, dict_size());
    tmp_index = indexes[i];
    indexes[i] = indexes[swap_with];
    indexes[swap_with] = tmp_index;
  }
}

GList *dict_all(){
  GList *tmp_list = NULL;
  gint i = 0;
  for (i; i < dictionary->len; ++i){
    g_list_append(tmp_list, (gchar*) g_ptr_array_index(dictionary, i));
  }
  return tmp_list;
}

gboolean dict_exists(gchar *word){
  gint i = 0;
  for (i; i < dictionary->len; ++i){
    if(g_strcmp0((gchar*)g_ptr_array_index(dictionary, i), word) == 0)
      return TRUE;
  }
  return FALSE;
}

gint compare_strings(gconstpointer a, gconstpointer b){
  return (gint) g_ascii_strcasecmp(*(const char **) a, *(const char **) b);
}

void dict_load_from_file(){
  gchar *filename =  BULLSHIT_BINGO_STORE_FILE;
  gchar *full_dictionary; 
  if(g_file_test(filename, G_FILE_TEST_EXISTS)){
    g_file_get_contents(filename, &full_dictionary, NULL, NULL); 
    gchar **full_dictionary_array;
    full_dictionary_array = g_strsplit(full_dictionary, "\n", 0);
    
    gint i = 0;    
    for(i; i < g_strv_length(full_dictionary_array); ++i){
      if(strcmp(full_dictionary_array[i], " ") > 0 && strcmp(g_strndup(full_dictionary_array[i],1), "#") > 0)
	g_ptr_array_add(dictionary, (gpointer)full_dictionary_array[i]);
    }
  }  
}

void dict_save_to_file(){
  gchar *new_dictionary = "";

  gint i = 0;
  for (i; i < dictionary->len; ++i){
    new_dictionary = g_strdup_printf("%s%s\n", new_dictionary, (gchar*)g_ptr_array_index(dictionary, i));
  }

  g_file_set_contents(BULLSHIT_BINGO_STORE_FILE, new_dictionary, -1, NULL);
}
