#ifndef INCLUDE_BULLSHIT_H
#define INCLUDE_BULLSHIT_H

#include <hildon/hildon-program.h>
#include <gtk/gtk.h>

#define BOARD_SIZE            5
#define BUTTON_WIDTH          160
#define BUTTON_HEIGHT         90
#define MAX_WORD_SIZE         32

#define APPLICATION_NAME      "Bullshit Bingo"

#define WORD_ADDED            "Word \"%s\" added."
#define NO_WORDS_SELECTED     "No words selected."
#define WORDS_REMOVED         "%d word(s) have been removed."
#define NOTHING_TYPED         "Please type anything."
#define WORD_ALREADY_EXISTS   "Word \"%s\" already exists."
#define WORD_FORMAT           "<small>%s</small>"

#define ADD_BUTTON_LABEL         "Add"
#define DELETE_BUTTON_LABEL      "Delete"
#define RESET_BUTTON_LABEL       "Reset"
#define DICTIONARY_BUTTON_LABEL  "Dictionary"
#define DICTIONARY_WINDOW_NAME   "Edit Dictionary"

/* Application UI data struct */
typedef struct _AppData AppData;
struct _AppData {
  HildonProgram *program;
  HildonWindow *window;
  osso_context_t *osso_context;
};

typedef struct {
  gint *x, *y;
} ButtonPosition;

//void word_button_toggled(GtkWidget*, GdkEventButton*, struct ButtonPosition*);
void word_button_toggled(GtkWidget*, ButtonPosition*);
void add_word_button_clicked(GtkWidget*);
void word_to_delete_toggled(GtkWidget*);
void delete_button_clicked();
void open_dictionary_button_clicked();
void close_button_clicked();
void reset_button_clicked();

static void create_board();
static void create_menu();
void reset_game_board();
void create_dictionary_window(GtkWidget*);
void reload_dictionary_table();

void show_info(gchar*);
void show_note(gchar*);

#endif
/* ifndef INCLUDE_BULLSHIT_H */

