#include <QPainter>
#include "shot.h"
#include <QDebug>

/* class constructor, parameter - current coordinates of ship */
Shot::Shot(QRect ship)
{
    /* set starting coordinates */
    x = ship.x() + 25;
    y = ship.y();

}


/* get painter object and draw shot */
void Shot::update(QPainter* painter)
{
    /* set draw parameters */
    painter->setPen(Qt::NoPen);
    painter->setBrush(Qt::red);

    painter->drawRect(x,y,5,5); // draw shot object
    y -= 5; // move shot object

}


/* check if the object is out of borders */
bool Shot::isOut()
{
    if (y <= 0)
        return true;
    else
        return false;
}


/* get current object coordinates */
QRect Shot::getRect()
{
    /* create and return QRect object */
    QRect temp(x,y,5,5);
    return temp;
}
