#include "bootscreenR.h"

#include <QDir>
#include <QTime>
#include <QSettings>
#include <QDebug>

BootScreenR::BootScreenR()
{
    settingsDir = "/opt/bootscreen/data/";
    logFile.setFileName("/opt/bootscreen/data/log.txt");

    if (!logFile.open(QIODevice::ReadWrite | QIODevice::Text))
        qDebug() << "Can't write log" << endl;

    QTextStream out(&logFile);
    //out << "log" << endl;
    QDir dir(settingsDir);

    settingsFile.setFileName(dir.filePath("bootscreen.conf"));
    if (settingsFile.exists()){
        QSettings tempSettings(settingsFile.fileName(),QSettings::IniFormat);
        bool random = tempSettings.value("random").toBool();
        if(random)
            selectRandomFile();
    }
    else
       out << "Can't read settings file" << endl;
}

void BootScreenR::selectRandomFile()
{
    QTextStream out(&logFile);
    //currentFile
    QSettings settings("/etc/hildon-welcome.d/0.conf",QSettings::IniFormat);
    if (!settings.isWritable())
        out << "Can't Write hildon-welcome settings" << endl;

    else{
        settings.beginGroup("hildon-welcome");
        QString currentFile = settings.value("filename").toString();

        QDir videosDir("/opt/bootscreen/media");
        videosDir.setFilter(QDir::Files | QDir::NoSymLinks);
        videosDir.setSorting(QDir::Name);
        QFileInfoList ls = videosDir.entryInfoList();
        for (int i = 0; i < ls.size(); ++i) {
            QFileInfo fileInfo = ls.at(i);
            if(fileInfo.absoluteFilePath() != currentFile)
                files.append(fileInfo.absoluteFilePath());
        }

        if(files.size()>0){
            QTime fixTime(0, 0, 0);
            qsrand(fixTime.secsTo(QTime::currentTime()));
            int randomNumb = qrand() % files.size();
            settings.setValue("filename", files.at(randomNumb));
        }
        else
            out << "Can't randomize: Only one file in the media directory." << endl;
    }
}

BootScreenR::~BootScreenR()
{
}
