#include <QtGui>
#include <QMainWindow>

#ifndef BOOTSCREEN_H
#define BOOTSCREEN_H


struct bootConfFile {
    QFileInfo name;
    QFileInfo confFile;
};

class BootScreen : public QMainWindow
{
     Q_OBJECT

public:
    BootScreen(QWidget *parent = 0);
    virtual ~BootScreen();

protected:
    void closeEvent(QCloseEvent *event);

private:
    void checkSettings();
    void createList();
    void writeSettings();
    void restoreSettings();
    void writeFiles();
    void createFile(QString filename, int index);
    bool random;
    QString hildonWelcome;
    QString settingsPath;
    QString videosDir;
    QFile settingsFile;
    QActionGroup *filterGroup;
    QAction *mRandom;
    QAction *mMultiple;
    QHash <QString, QString> mediaFiles;
    QListWidget *list;
    QPushButton *up;
    QPushButton *down;

private slots:
    void addVideo();
    void removeVideos();
    void disableSelection(bool state);
    void selectMultiple(bool state);
    void moveUp();
    void moveDown();
};

#endif // BOOTSCREEN_H
