#include "bootscreen.h"

#include <QtMaemo5>

BootScreen::BootScreen(QWidget *parent)
    : QMainWindow(parent)
{
    hildonWelcome = "/etc/hildon-welcome.d/";
    videosDir = "/opt/bootscreen/media/";
    checkSettings();

    filterGroup = new QActionGroup(this);
    filterGroup->setExclusive(true);
    mRandom = new QAction(tr("Random"), filterGroup);
    mRandom->setCheckable(true);
    mMultiple = new QAction(tr("Multiple"), filterGroup);
    mMultiple->setCheckable(true);

    //laod settings
    if(random)
        mRandom->setChecked(true);
    else
        mMultiple->setChecked(true);


    connect(mRandom, SIGNAL(toggled(bool)), this, SLOT(disableSelection(bool)));
    connect(mMultiple, SIGNAL(toggled(bool)), this, SLOT(selectMultiple(bool)));

    menuBar()->addActions(filterGroup->actions());

    menuBar()->addAction(tr("Add"), this, SLOT(addVideo()));
    menuBar()->addAction(tr("Remove"), this, SLOT(removeVideos()));

    createList();
}

void BootScreen::checkSettings()
{
    QDir dir("/home/user");
    if (!dir.cd(".bootscreen")) {
         qWarning("Cannot find the \".bootscreen/\" directory");
         dir.mkdir(".bootscreen");
         if (!dir.cd(".bootscreen")) {
              qWarning("Cannot create the \".bootscreen/\" directory");

              //terminar applicacao
          }
     }
     settingsFile.setFileName(dir.filePath("settings.ini"));
     if (!settingsFile.exists())
        restoreSettings();
     else{
         QSettings tempSettings(settingsFile.fileName(),QSettings::IniFormat);
         random = tempSettings.value("random").toBool();
     }
}

void BootScreen::createList()
{
    QWidget *central = new QWidget();

    QVBoxLayout *lay = new QVBoxLayout(central);
    lay->setSpacing(8);
    lay->setContentsMargins(0, 0, 0, 15);

    list = new QListWidget();


    list->setSelectionMode(QAbstractItemView::MultiSelection);

    QDir dirHildon(hildonWelcome);
    dirHildon.setFilter(QDir::Files | QDir::NoSymLinks);
    dirHildon.setSorting(QDir::Name);

    QFileInfoList ls = dirHildon.entryInfoList();
    for (int i = 0; i < ls.size(); ++i) {
        QFileInfo fileInfo = ls.at(i);
        QSettings tempSettings(fileInfo.absoluteFilePath(),QSettings::IniFormat);
        tempSettings.beginGroup("hildon-welcome");

        QFileInfo prettyName(tempSettings.value("filename").toString());
        list->addItem(QString("%1").arg(prettyName.fileName()));
        mediaFiles[prettyName.fileName()] = tempSettings.value("filename").toString();


        qDebug() << fileInfo.absoluteFilePath() << endl;
        qDebug() << tempSettings.value("filename") << endl;
    }


    QListWidgetItem *temp;
    int listSize = list->count();
    //activate items
    for(int i = 0; i < listSize; i++){
        temp = list->item(i);
        if(temp)
            temp->setSelected(true);
    }

    if(random)
        list->setSelectionMode(QAbstractItemView::NoSelection);

    //Add hands video

    if(!mediaFiles.contains("Hands-v32-h264.avi")){
        QFileInfo handsTmp("/usr/share/hildon-welcome/media/Hands-v32-h264.avi");
        if(handsTmp.exists()){
            mediaFiles[handsTmp.fileName()] = handsTmp.absoluteFilePath();
            list->addItem(QString("%1").arg(handsTmp.fileName()));
        }
    }

    QDir dir(videosDir);
    dir.setFilter(QDir::Files | QDir::NoSymLinks);
    dir.setSorting(QDir::Name);
    //if empty show warning to add a file via menu

    ls = dir.entryInfoList();
    for (int i = 0; i < ls.size(); ++i) {
        QFileInfo fileInfo = ls.at(i);
        if(!mediaFiles.contains(fileInfo.fileName())){
            mediaFiles[fileInfo.fileName()] = fileInfo.absoluteFilePath();
            list->addItem(QString("%1").arg(fileInfo.fileName()));
        }
        qDebug() << fileInfo.absoluteFilePath() << endl;

    }

   // for(int i =0; i < 8; i++){
     //  list->addItem("bbr");
    //}

    lay->addWidget(list);

    QHBoxLayout *layButtons = new QHBoxLayout();
    up = new QPushButton("Up");
    down = new QPushButton("Down");

    if(random){
        up->setEnabled(false);
        down->setEnabled(false);
    }

    layButtons->addWidget(up);
    layButtons->addWidget(down);
    lay->addLayout(layButtons);

    connect(up, SIGNAL(clicked()), this, SLOT(moveUp()));
    connect(down, SIGNAL(clicked()), this, SLOT(moveDown()));

    setCentralWidget(central);
}

void BootScreen::addVideo()
{
    QString filePath = QFileDialog::getOpenFileName(this,
        tr("Open file"), "/home/user/MyDocs", tr("Video Files (*.avi)"));
    qDebug() << filePath << endl;

    if(filePath != ""){
        QFile fileCopy(filePath);
        QFileInfo fileInfo(filePath);
        QString newFilePath = videosDir + fileInfo.fileName();
        qDebug() << newFilePath << endl;
        qDebug() << fileInfo.size() << endl;
        if(fileInfo.size() > 11100000)
            QMaemo5InformationBox::information(this, "<font color=black><b>Error:</b> The selected file is too big</font>",
                                                        QMaemo5InformationBox::DefaultTimeout);

        else{
            QFile tempTest(newFilePath);
            if(tempTest.exists())
                QMaemo5InformationBox::information(this, "<font color=black><b>Error:</b> The file already exists</font>",
                                                            QMaemo5InformationBox::DefaultTimeout);
            else{
                bool result = fileCopy.copy(newFilePath);
            // tamanho
                if(result)
                    list->addItem(QString("%1").arg(fileInfo.fileName()));
                else
                    QMaemo5InformationBox::information(this, "<font color=black>Error copying file</font>",
                                                                QMaemo5InformationBox::DefaultTimeout);
            }
        }

        //add somewhere
    }

}

void BootScreen::removeVideos()
{
    QListWidgetItem *temp;
    QList <QListWidgetItem *> selectedItems = list->selectedItems();
    if(selectedItems.size()>0){
        QDir vidDir(videosDir);
        QMessageBox msgBox;
        int ret = QMessageBox::information(this, tr("Remove files"), tr("Remove selected file(s) ?"), QMessageBox::Yes | QMessageBox::No);

        if(ret == QMessageBox::Yes){
            for(int i=0; i< selectedItems.size();i++){
                temp = selectedItems.at(i);
                bool result = vidDir.remove(temp->text());
                qDebug() << result << " :" << temp->text() << endl;

                if(result){
                    int rw = list->row(temp);
                    temp = list->takeItem(rw);
                    delete temp;
                }
            }
        }
    }

}

void BootScreen::moveUp()
{
    int currentRow = list->currentRow();
    if (currentRow == 0) return;
    QListWidgetItem * currentItem = list->takeItem(currentRow);
    list->insertItem(currentRow - 1, currentItem);
    list->setCurrentRow(currentRow - 1);
}

void BootScreen::moveDown()
{
    int currentRow = list->currentRow();
    if (currentRow >= list->count()-1) return;
    QListWidgetItem * currentItem = list->takeItem(currentRow);
    list->insertItem(currentRow + 1, currentItem);
    list->setCurrentRow(currentRow + 1);
}

void BootScreen::disableSelection(bool state)
{
    if(state){
        up->setEnabled(false);
        down->setEnabled(false);
        QListWidgetItem *temp;
        int listSize = list->count();
        //disable items
        QTime fixTime(0, 0, 0);
        qsrand(fixTime.secsTo(QTime::currentTime()));
        int randomNumb = qrand() % listSize;
        qDebug() << randomNumb << endl;
        for(int i = 0; i < listSize; i++){
            temp = list->item(i);
            if(temp){
                if(i == randomNumb)
                    temp->setSelected(true);
                else
                    temp->setSelected(false);
            }
        }
        list->setSelectionMode(QAbstractItemView::NoSelection);
        QMaemo5InformationBox::information(this, "<font color=black><b>Random mode:</b> Selection disabled</font>",
                                                    QMaemo5InformationBox::DefaultTimeout);
    }

    random = true;
}

void BootScreen::selectMultiple(bool state)
{
    if(state){
        up->setEnabled(true);
        down->setEnabled(true);
        list->setSelectionMode(QAbstractItemView::MultiSelection);
        random = false;
    }
}

void BootScreen::writeSettings()
{
    QSettings settings(settingsFile.fileName(),QSettings::IniFormat);
    settings.setValue("random", random);
}

void BootScreen::restoreSettings()
{
     qDebug() << settingsFile.fileName() << endl;

     if (!settingsFile.open(QIODevice::ReadWrite | QIODevice::Text))
        qWarning("Cannot create the settings file"); //abord

     QTextStream out(&settingsFile);
     out << "random=false" << endl;

     random = false;
}

void BootScreen::writeFiles(){

    //remove old files
    QDir dir(hildonWelcome);
    dir.setFilter(QDir::Files);

    QFileInfoList ls = dir.entryInfoList();
    for (int i = 0; i < ls.size(); ++i) {
        QFileInfo fileInfo = ls.at(i);
        bool result = dir.remove(fileInfo.fileName());
        qDebug() << result << " :" << fileInfo.fileName() << endl;
    }

    QListWidgetItem *temp;
    for(int i=0; i< list->count();i++){
        temp = list->item(i);
        if(temp->isSelected())
            if(random)
                 createFile(temp->text(), 0);
            else
                createFile(temp->text(), i);
    }
}

void BootScreen::createFile(QString filename, int index)
{
    QString ind = QString::number(index);
    if(mediaFiles.contains(filename)){
        QFile confFile(hildonWelcome + ind + ".conf");
        qDebug() << confFile.fileName() << endl;
        if (!confFile.open(QIODevice::ReadWrite | QIODevice::Text))
           qWarning("Cannot create the settings file"); //abord

        else{
            QString filePath = mediaFiles.value(filename);
            QTextStream out(&confFile);
            out << "[hildon-welcome]" << endl;
            out << "filename=" << filePath << endl;
        }
    }
    else
        qDebug() << "print a error" << endl;
}

void BootScreen::closeEvent(QCloseEvent *event)
{
    writeSettings();
    writeFiles();
    event->accept();
}

BootScreen::~BootScreen()
{
}


