/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Binary Clock.
 *
 *  Binary Clock is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Binary Clock is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Binary Clock.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QDateTime>
#include <QTime>

#include "bcdclockwidget.h"

BcdClockWidget::BcdClockWidget(QWidget *parent) :
    ClockWidget(parent)
{
    layout = new QHBoxLayout(this);

    hoursTenWidget = new VerticalBinaryDisplayWidget(2, 2, 4);
    addBinaryDisplayWidget(hoursTenWidget, layout);

    hoursOneWidget = new VerticalBinaryDisplayWidget(4, 1);
    addBinaryDisplayWidget(hoursOneWidget, layout);

    minutesTenWidget = new VerticalBinaryDisplayWidget(3, 4, 4);
    addBinaryDisplayWidget(minutesTenWidget, layout);

    minutesOneWidget = new VerticalBinaryDisplayWidget(4, 3);
    addBinaryDisplayWidget(minutesOneWidget, layout);

    if(showSeconds){
        secondsTenWidget = new VerticalBinaryDisplayWidget(3, 2, 4);
        addBinaryDisplayWidget(secondsTenWidget, layout);

        secondsOneWidget = new VerticalBinaryDisplayWidget(4, 1);
        addBinaryDisplayWidget(secondsOneWidget, layout);
    }else{
        secondsOneWidget = NULL;
        secondsTenWidget = NULL;
    }

    setFixedSize(sizeHint());
    layout->setSizeConstraint(QLayout::SetMinimumSize);

    updateTime();
}

BcdClockWidget::~BcdClockWidget(){
    if(secondsOneWidget != NULL){
        delete secondsOneWidget;
    }
    if(secondsTenWidget != NULL){
        delete secondsTenWidget;
    }
    delete minutesOneWidget;
    delete minutesTenWidget;
    delete hoursOneWidget;
    delete hoursTenWidget;

    delete layout;
}

QSize BcdClockWidget::sizeHint(){
    QSize size((((showSeconds) ? 6 : 4) * hoursOneWidget->getElementSize())
                 + (((showSeconds) ? 5 : 3) * layout->spacing())
                 + (2 * layout->margin()),
                 (4 * hoursOneWidget->getElementSize())
                 + (2 * layout->margin())
                 );
#ifdef Q_WS_MAEMO_5
    size.setHeight(size.height() + 10);
    size.setWidth(size.width() + 50);
#endif

    return size;
}

void BcdClockWidget::updateTime(){
    QTime time = QDateTime::currentDateTime().time();

    if(secondsOneWidget != NULL){
        secondsOneWidget->updateValue(time.second() % 10);
    }
    if(secondsTenWidget != NULL){
        secondsTenWidget->updateValue(time.second() / 10);
    }
    minutesOneWidget->updateValue(time.minute() % 10);
    minutesTenWidget->updateValue(time.minute() / 10);
    hoursOneWidget->updateValue(time.hour() % 10);
    hoursTenWidget->updateValue(time.hour() / 10);
}
