/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of Binary Clock.
 *
 *  Binary Clock is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Binary Clock is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Binary Clock.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QDateTime>
#include <QTime>

#include "bcdclockwidget.h"

BcdClockWidget::BcdClockWidget(QWidget *parent) :
    ClockWidget(parent)
{
    layout = new QHBoxLayout(this);

    hoursTenWidget = new VerticalBinaryDisplayWidget(2, 2, 4);
    connect(this, SIGNAL(settingsChanged()), hoursTenWidget, SLOT(applySettings()));
    layout->addWidget(hoursTenWidget);

    hoursOneWidget = new VerticalBinaryDisplayWidget(4, 1);
    connect(this, SIGNAL(settingsChanged()), hoursOneWidget, SLOT(applySettings()));
    layout->addWidget(hoursOneWidget);

    minutesTenWidget = new VerticalBinaryDisplayWidget(3, 4, 4);
    connect(this, SIGNAL(settingsChanged()), minutesTenWidget, SLOT(applySettings()));
    layout->addWidget(minutesTenWidget);

    minutesOneWidget = new VerticalBinaryDisplayWidget(4, 3);
    connect(this, SIGNAL(settingsChanged()), minutesOneWidget, SLOT(applySettings()));
    layout->addWidget(minutesOneWidget);

    if(showSeconds){
        secondsTenWidget = new VerticalBinaryDisplayWidget(3, 2, 4);
        connect(this, SIGNAL(settingsChanged()), secondsTenWidget, SLOT(applySettings()));
        layout->addWidget(secondsTenWidget);

        secondsOneWidget = new VerticalBinaryDisplayWidget(4, 1);
        connect(this, SIGNAL(settingsChanged()), secondsOneWidget, SLOT(applySettings()));
        layout->addWidget(secondsOneWidget);
    }else{
        secondsOneWidget = NULL;
        secondsTenWidget = NULL;
    }

    setFixedSize(sizeHint());
    layout->setSizeConstraint(QLayout::SetMinimumSize);

    updateTime();
}

BcdClockWidget::~BcdClockWidget(){
    if(secondsOneWidget != NULL){
        delete secondsOneWidget;
    }
    if(secondsTenWidget != NULL){
        delete secondsTenWidget;
    }
    delete minutesOneWidget;
    delete minutesTenWidget;
    delete hoursOneWidget;
    delete hoursTenWidget;

    delete layout;
}

QSize BcdClockWidget::sizeHint(){
    return QSize((((showSeconds) ? 6 : 4) * hoursOneWidget->getElementSize()) + (((showSeconds) ? 5 : 3) * layout->margin()),
                 (4 * hoursOneWidget->getElementSize()) + (2 * layout->margin())
#ifdef Q_WS_MAEMO_5
                 + 6
#endif
                 );
}

void BcdClockWidget::updateTime(){
    QTime time = QDateTime::currentDateTime().time();

    if(secondsOneWidget != NULL){
        secondsOneWidget->updateValue(time.second() % 10);
    }
    if(secondsTenWidget != NULL){
        secondsTenWidget->updateValue(time.second() / 10);
    }
    minutesOneWidget->updateValue(time.minute() % 10);
    minutesTenWidget->updateValue(time.minute() / 10);
    hoursOneWidget->updateValue(time.hour() % 10);
    hoursTenWidget->updateValue(time.hour() / 10);
}
