from datetime import datetime
import gtk
import gobject
import hildon
import hildondesktop

global clock_style, show_seconds
clock_style = 0
show_seconds = True

def area_expose_cb(area, event):
    gc = area.get_style().fg_gc[gtk.STATE_NORMAL]

    gc.foreground = area.get_colormap().alloc_color(65535, 65535, 65535)

    if clock_style == 0:
        draw_binary_clock(area.window, gc)
    elif clock_style == 1:
        draw_bcd_clock(area.window, gc)

def draw_bcd_clock(drawable, gc):
    time = datetime.today()
    draw_bits_vertically(2, 16, time.hour / 10, 2, drawable, gc)
    draw_bits_vertically(12, 0, time.hour % 10, 4, drawable, gc)
    draw_bits_vertically(26, 8, time.minute / 10, 3, drawable, gc)
    draw_bits_vertically(36, 0, time.minute % 10, 4, drawable, gc)
    if show_seconds:
        draw_bits_vertically(50, 8, time.second / 10, 3, drawable, gc)
        draw_bits_vertically(60, 0, time.second % 10, 4, drawable, gc)

def draw_binary_clock(drawable, gc):
    time = datetime.today()
    draw_bits_horizontally(12, 2, time.hour, 5, drawable, gc)
    draw_bits_horizontally(0, 14, time.minute, 6, drawable, gc)
    if show_seconds:
        draw_bits_horizontally(0, 26, time.second, 6, drawable, gc)

def draw_bits_horizontally(x, y, value, n, drawable, gc):
    for i in range(n):
      drawable.draw_arc(gc, (value >> (n - i - 1) & 1) > 0, x + 2 + (12 * i), y, 8, 8, 0, 360 *64)

def draw_bits_vertically(x, y, value, n, drawable, gc):
    for i in range(n):
      drawable.draw_arc(gc, (value >> (n - i - 1) & 1) > 0, x, y + 1 + (8 * i), 6, 6, 0, 360 *64)

def redraw_area(area):
    if (not show_seconds) and (clock_style == 1):
        area.queue_draw_area(0, 0, 47, 36)
    else:
        area.queue_draw_area(0, 0, 76, 36)

def set_area_size(area):
    if (not show_seconds) and (clock_style == 1):
        area.set_size_request(47, 36)
    else:
        area.set_size_request(76, 36)

def update_cb(plugin):
    redraw_area(plugin.drawingArea)
    return True	

class BinaryClockStatusAreaPlugin(hildondesktop.StatusMenuItem):
    def __init__(self):
        hildondesktop.StatusMenuItem.__init__(self)

        button = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Binary Clock")
        image = gtk.Image()
        image.set_from_file("/usr/share/icons/hicolor/48x48/apps/binaryclock_status_area_plugin.png")
        button.set_image(image)
        button.set_alignment(0, 0.5, 0, 0)
        button.connect("clicked", self.settingsCb)
        self.add(button)
        button.show()

        self.drawingArea = gtk.DrawingArea()
      	self.drawingArea.connect("expose-event", area_expose_cb)

        self.set_status_area_widget(self.drawingArea)

        set_area_size(self.drawingArea)
      	self.drawingArea.show()

        self.show()

        gobject.timeout_add(1000, update_cb, self)

    def settingsCb(self, widget, data=None):
        dialog = hildon.Dialog()
        dialog.set_title("Binary Clock Status Area Plugin Settings")

        self.showSecondsButton = hildon.CheckButton(gtk.HILDON_SIZE_FINGER_HEIGHT)
        self.showSecondsButton.set_active(show_seconds)
        self.showSecondsButton.set_label("Show seconds")
        dialog.vbox.pack_start(self.showSecondsButton, True, True, 0)
        self.showSecondsButton.show()

        self.selector = hildon.TouchSelector(text = True)
        self.selector.append_text("Binary Clock")
        self.selector.append_text("BCD Clock")
        self.styleButton = hildon.PickerButton(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.styleButton.set_title("Clock Style")
        self.styleButton.set_selector(self.selector)
        self.styleButton.set_active(clock_style)
        dialog.vbox.pack_start(self.styleButton, True, True, 0)
        self.styleButton.show()

        okButton = hildon.Button(gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Ok")
        okButton.connect("clicked", self.settingsOkCb, dialog)
        dialog.action_area.pack_start(okButton, True, True, 0)
        okButton.show()

        dialog.show_all()

    def settingsOkCb(self, widget, dialog):
        global clock_style, show_seconds

        clock_style = self.styleButton.get_active()
        show_seconds = self.showSecondsButton.get_active()

        set_area_size(self.drawingArea)
        redraw_area(self.drawingArea)
    
        dialog.destroy()


hd_plugin_type = BinaryClockStatusAreaPlugin


