#!/bin/sh

# Override the prompt only for bash
[ -z "$BASH" ] && continue

# ... and only in interactive mode
case "$-" in
    *i*)
        ;;
    *)
        continue
esac

# set variable identifying the chroot you work in (used in the prompt below)
if [ -z "$debian_chroot" -a -r /etc/debian_chroot ]; then
    debian_chroot=$(cat /etc/debian_chroot)
fi

# Comment out to disable colored prompt
COLOR=yes
# Uncomment for a bright prompt (better looking on dark background)
#BRIGHT=";1"

# For color terminals set a colored prompt.
# We have to try to please both those with dark background as well
# as those with a bright background.
case $COLOR-$TERM in
  yes-linux* | yes-xterm* | yes-rxvt* | yes-screen* | yes-Eterm* | yes-vt10* | yes-rxvt*)
    # Since BASH cannot assume something about terminals, we have to point him
    # whenever characters in prompt are "visible" or "invisible" by using
    # \[ (start invisible) and \] (end invisible) characters
    PS1="\[\033[0${BRIGHT}m\][${debian_chroot:+\[\033[31m\]$debian_chroot\[\033[0${BRIGHT}m\]|}\[\033[33m\]\${SHLVL}\[\033[0${BRIGHT}m\]|\[\033[34m\]\u\[\033[0${BRIGHT}m\]@\[\033[32m\]\h\[\033[0${BRIGHT}m\]|\[\033[36m\]\w\[\033[0${BRIGHT}m\]]\[\033[0m\]"
    PS2="\[\033[0${BRIGHT}m\]>\[\033[0m\]"
    ;;
  *)
    PS1="[${debian_chroot:+$debian_chroot|}\${SHLVL}|\u@\h|\w]"
    PS2=">"
    ;;
esac

export PS1 PS2
unset debian_chroot COLOR
