#include <glib.h>
#include <telepathy-glib/dbus.h>

#include "azimuth.h"

#define AZIMUTH_BUS_NAME "org.maemo.Azimuth"

int
main (int argc,
    char **argv)
{
  Azimuth *azimuth;
  TpDBusDaemon *dbus;
  GError *error = NULL;

  g_type_init ();

  dbus = tp_dbus_daemon_dup (&error);
  if (dbus == NULL)
    {
      g_print ("Failed to get bus: %s\n", error->message);
      g_error_free (error);
      return 1;
    }

  if (!tp_dbus_daemon_request_name (dbus, AZIMUTH_BUS_NAME, FALSE, &error))
    {
      g_print ("Failed to request bus name: %s\n", error->message);
      g_error_free (error);
      return 1;
    }

  azimuth = azimuth_new ();
  azimuth_run (azimuth);

  tp_dbus_daemon_release_name (dbus, AZIMUTH_BUS_NAME, NULL);

  g_object_unref (azimuth);
  g_object_unref (dbus);
  return 0;
}
