/*
 * controlpanel-applet.c.c - Source for Azimuth's control panel applet
 * Copyright (C) 2010 Collabora
 * @author Alban Crequy <alban.crequy@collabora.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <libintl.h>
#include <libosso.h>
#include <gconf/gconf-client.h>
#include <hildon/hildon.h>
#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>

#include "azimuth-gconf.h"

static GtkWidget* button_enabled = NULL;
static GtkWidget* button_blur = NULL;
static GtkWidget* button_start_gps = NULL;
static GConfClient *gconf_client;

static void
enabled_toggled (HildonCheckButton *button, gpointer user_data)
{
  gboolean active;

  active = hildon_check_button_get_active (button);
  if (active)
    {
      gtk_widget_set_sensitive (button_blur, TRUE);
      gtk_widget_set_sensitive (button_start_gps, TRUE);
    }
  else
    {
      gtk_widget_set_sensitive (button_blur, FALSE);
      gtk_widget_set_sensitive (button_start_gps, FALSE);
    }
}

static GtkWidget*
azimuth_create_check_button (const gchar *text,
                             GCallback cb,
                             const gchar *gconf_key)
{
  GtkWidget *b;
  gboolean checked;

  b = hildon_check_button_new (HILDON_SIZE_FINGER_HEIGHT |
      HILDON_SIZE_AUTO_WIDTH);
  gtk_button_set_label (GTK_BUTTON (b), text);
  if (cb != NULL)
    g_signal_connect (b, "toggled", cb, NULL);
  checked = gconf_client_get_bool (gconf_client, gconf_key,
      NULL);
  hildon_check_button_set_active (HILDON_CHECK_BUTTON (b), checked);

  return b;
}

static GtkWidget*
create_main_dialog (gpointer window, osso_context_t *osso)
{
  GtkWidget *dialog;
  GtkWidget *bSave;

  dialog = g_object_new (GTK_TYPE_DIALOG,
      "transient-for", GTK_WINDOW (window),
      "destroy-with-parent", TRUE,
      "resizable", TRUE,
      "has-separator", FALSE,
      "modal", TRUE,
      NULL);
  gtk_window_set_title (GTK_WINDOW (dialog),
      "Publish position to contacts");

  bSave = gtk_dialog_add_button (GTK_DIALOG (dialog),
      dgettext ("hildon-libs", "wdgt_bd_save"),
      GTK_RESPONSE_OK);

  button_blur = azimuth_create_check_button (
      "Truncate your position", NULL, AZIMUTH_GCONF_KEY_BLUR);
  button_start_gps = azimuth_create_check_button (
      "Start GPS (drains battery)", NULL, AZIMUTH_GCONF_KEY_START_GPS);

  button_enabled = azimuth_create_check_button (
      "Publish position when GPS is running", G_CALLBACK (enabled_toggled),
      AZIMUTH_GCONF_KEY_ENABLED);
  enabled_toggled (HILDON_CHECK_BUTTON (button_enabled), NULL);

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialog)->vbox), button_enabled,
      FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialog)->vbox), button_blur,
      FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialog)->vbox), button_start_gps,
      FALSE, FALSE, 0);

  gtk_widget_show_all (dialog);

  return dialog;
}

static void
save (void)
{
  gboolean enabled;
  gboolean blur;
  gboolean start_gps;

  enabled = hildon_check_button_get_active (HILDON_CHECK_BUTTON (
        button_enabled));
  blur = hildon_check_button_get_active (HILDON_CHECK_BUTTON (
        button_blur));
  start_gps = hildon_check_button_get_active (HILDON_CHECK_BUTTON (
        button_start_gps));

  gconf_client_set_bool (gconf_client, AZIMUTH_GCONF_KEY_ENABLED, enabled,
      NULL);
  gconf_client_set_bool (gconf_client, AZIMUTH_GCONF_KEY_BLUR, blur,
      NULL);
  gconf_client_set_bool (gconf_client, AZIMUTH_GCONF_KEY_START_GPS, start_gps,
      NULL);
}

osso_return_t
execute (osso_context_t *osso, gpointer data,
    gboolean user_activated)
{
  GtkWidget *dialog;
  gint ret;

  gconf_client = gconf_client_get_default ();

  dialog = create_main_dialog (data, osso);

  ret = gtk_dialog_run (GTK_DIALOG (dialog));

  if (ret == GTK_RESPONSE_OK)
    save ();

  gtk_widget_destroy (dialog);

  g_object_unref (gconf_client);
  gconf_client = NULL;

  return OSSO_OK;
}
