/*
 * position-publisher.h - Header for PositionPublisher
 * Copyright (C) 2010 Guillaume Desmottes
 * @author Guillaume Desmottes <gdesmott@gnome.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __POSITION_PUBLISHER_H__
#define __POSITION_PUBLISHER_H__

#include <glib-object.h>

G_BEGIN_DECLS

typedef struct _PositionPublisher PositionPublisher;
typedef struct _PositionPublisherClass PositionPublisherClass;

struct _PositionPublisherClass {
    GObjectClass parent_class;
};

struct _PositionPublisher {
    GObject parent;
};

GType position_publisher_get_type (void);

/* TYPE MACROS */
#define POSITION_PUBLISHER_TYPE \
  (position_publisher_get_type())
#define POSITION_PUBLISHER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), POSITION_PUBLISHER_TYPE, PositionPublisher))
#define POSITION_PUBLISHER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), POSITION_PUBLISHER_TYPE, PositionPublisherClass))
#define POSITION_IS_PUBLISHER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), POSITION_PUBLISHER_TYPE))
#define POSITION_IS_PUBLISHER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), POSITION_PUBLISHER_TYPE))
#define POSITION_PUBLISHER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), POSITION_PUBLISHER_TYPE, PositionPublisherClass))

PositionPublisher * position_publisher_new (void);

void position_publisher_set_blur (PositionPublisher *self,
    gboolean blur);

G_END_DECLS

#endif /* #ifndef __POSITION_PUBLISHER_H__*/
