#include <glib.h>

#include "connection-watcher.h"

static void
connection_added_cb (ConnectionWatcher *watcher,
    TpConnection *conn)
{
  g_print ("conn added: %s\n", tp_proxy_get_object_path (conn));
}

int
main (int argc,
    char **argv)
{
  GMainLoop *loop;
  ConnectionWatcher *watcher;

  g_type_init ();

  loop = g_main_loop_new (NULL, FALSE);
  watcher = connection_watcher_new ();

  g_signal_connect (watcher, "connection-added",
      G_CALLBACK (connection_added_cb), NULL);

  connection_watcher_start (watcher);

  g_print ("run\n");
  g_main_loop_run (loop);

  g_object_unref (watcher);
  g_main_loop_unref (loop);
  return 0;
}
