#include "mainwindow.h"
#include "central.h"
#include <QAction>
#include <QApplication>
#include <QMenu>
#include <QMenuBar>
#include <QMessageBox>
#include <QScrollArea>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    w=new Central();

    QScrollArea *scrollArea=new QScrollArea;

    scrollArea->setWidget(w);
    w->setMinimumWidth(790);

    setCentralWidget(scrollArea);

    createActions();
    createMenus();
	
    setWindowTitle("AutoRemoveSms");
}

MainWindow::~MainWindow()
{

}

void MainWindow::createActions()
{
    aboutAction = new QAction(tr("&About"), this);
    aboutQtAction = new QAction("About QT", this);
    connect(aboutAction, SIGNAL(triggered()), this, SLOT(about()));
    connect(aboutQtAction, SIGNAL(triggered()), this, SLOT(aboutQt()));
}

void MainWindow::createMenus()
{
    QMenu *menu;
    menu = menuBar()->addMenu(tr("MENU TITLE"));
    menu->addAction(aboutAction);
    menu->addAction(aboutQtAction);
}

void MainWindow::about()
{
    QMessageBox::about(this, tr("About AutoRemoveSms"),
                tr("<h2>AutoRemoveSms 0.4.1</h2>"
                   "<p>"
                   "<p>Written by GGiovanni (ggiovanni88@yahoo.it)"));

}

void MainWindow::aboutQt()
{
    QApplication::aboutQt();
}
