#!/usr/bin/env python

import sys

def _cmd_apply_blacklist(): #{{{1
    from PyQt4.QtCore import QCoreApplication
    from ACE_settings import ACESettings
    from ACE_file     import ACEFile
    from ACE_encoding import ACEEncoding
    from ACE_utils    import apply_blacklist

    app = QCoreApplication(sys.argv)

    settings = ACESettings()
    blacklists = settings.getBlacklist()

    dicts = ACEFile()
    dicts.setEncoding(settings.getEncoding())
    dicts.read()

    changed = False
    for i in dicts.getLanguages():
        if i in blacklists:
            dictList = dicts.getDict(i)

            if apply_blacklist(dictList, blacklists[i]):
                dicts.setDict(i, dictList)
                changed = True

    if changed:
        dicts.write()

def _cmd_run_gui(): #{{{1
    from PyQt4.QtGui import QApplication
    import traceback

    app = QApplication(sys.argv)

    try:
        from ACE_gui import ACEMainWindow
        w = ACEMainWindow()
        w.show()
        w.setupMenu()
        w.setupScreen()
        w.loadData()

        app.exec_()
    except Exception, e:
        from PyQt4.QtGui import QMessageBox
        QMessageBox.critical(None, 'Error', traceback.format_exc(2))

if __name__ == '__main__': #{{{1

    if '--apply-blacklist' in sys.argv:
        _cmd_apply_blacklist()
    else:
        _cmd_run_gui()

    sys.exit()
