#!/usr/bin/env python

import locale

localeOverrides = {
                   'en': 'CP1252',
                   'ru': 'CP1251',
                  }

class ACEEncodingDecodeException(Exception): #{{{1
    def __init__(self, encoding):
        self.msgsource = 'Error decoding string'
        self.errmsg    = 'Encoding tried was %s' % encoding

    def __str__(self):
        return "%s: %s" % (self.msgsource, self.errmsg)

class ACEEncoding(): #{{{1
    def __init__(self): #{{{2
        sys_locale   = locale.getdefaultlocale()
        sys_language = sys_locale[0][0:2]

        if sys_language in localeOverrides:
            sys_encoding = localeOverrides[sys_language]
        else:
            sys_encoding = self._findEncoding(sys_locale[0])

        self._encoding = sys_encoding
        self._sysEncoding = sys_encoding

    def _findEncoding(self, strng): #{{{2
        norm_locale = locale.normalize(strng)
        encoding = 'CP1252'

        if '.' in norm_locale:
            encoding = norm_locale.split('.')[1]
        elif '_' in strng:
            encoding = self._findEncoding(strng.split('_')[1])

        return encoding

    def fromQString(self, strng): #{{{2
        return unicode(strng.toUtf8(), 'utf-8').encode(self._encoding)

    def toQString(self, strng): #{{{2
        try:
            qStrng = unicode(strng, self._encoding)
        except Exception, e:
            raise ACEEncodingDecodeException(self._encoding)

        return qStrng

    def getEncoding(self): #{{{2
        enc = self._encoding

        if enc == self._sysEncoding:
            return 'Default'
        else:
            return enc

    def setEncoding(self, enc): #{{{2
        if enc == 'Default':
            self._encoding = self._sysEncoding
        else:
            self._encoding = self.fromQString(enc)
