#ifndef IMAGEWIDGET_H
#define IMAGEWIDGET_H

#include <QLabel>
#include <QPixmap>

class ImageWidget : public QLabel
{
    Q_OBJECT
public:
    enum ImageSize {
        THUMBNAIL,
        ACTUALSIZE
    };

    explicit ImageWidget(const QPixmap &image, QWidget *parent = 0, Qt::WindowFlags f = 0);
    ~ImageWidget() {}

    virtual void mouseReleaseEvent(QMouseEvent *);
    virtual void mousePressEvent(QMouseEvent *ev);

public slots:
        void playSound();

signals:
    void clicked(ImageWidget *);

private:
    QPointF startPoint;

};

#endif // IMAGEWIDGET_H
