'''
Advanced Power Battery Wraper BQ27200 Alternative
2011-2012(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

from advpowcommon.util.execn import *
from advpowcommon.util.format import *
from wrappers.battery.AbstractBattery import AbstractBattery

class BatteryBQ27200A(AbstractBattery):

  bq_path = '/org/freedesktop/Hal/devices/computer_power_supply_battery_bq27200_0'
  bq_node = 'org.freedesktop.Hal'
  bq_iface = 'org.freedesktop.Hal.Device'

  def pre_init(self):
    self.depends['packages'] = {'kernel-power': '1:2.6.28-10power47'}
    self.interfaces_map = {'BQ27200': (self.bq_node, self.bq_path, self.bq_iface)}

  def get_friendly_name(self):
    return 'BQ27200 Alternative'

  def get_default_dbus_signals(self):
    return {'status': {'path': self.bq_path,
                       'dbus_interface': self.bq_iface,
                       'signal_name': 'PropertyModified'}}

  def post_init(self):
    pass
#    self.get_status()

  def custom_available(self):
    result = get_shell_command_output('lshal | grep bq27200').replace('\n', '')
    return result != ''

  def handle_battery_status(self, value, props, force=False):
    signals = [str(x[0]) for x in props]
    values = {}
    if 'battery.voltage.current' in signals or force:
      values['voltage'] = int(self.interfaces['BQ27200'].GetPropertyInteger(u'battery.voltage.current'))
      values['percentage'] = self.get_percentage(values['voltage'])
      if not 'battery.remaining_time' in signals:
        signals.append('battery.remaining_time')
    if 'battery.reporting.last_full' in signals or force:
      values['design'] = int(self.interfaces['BQ27200'].GetPropertyInteger(u'battery.reporting.last_full'))
    if 'battery.reporting.current' in signals or force:
      values['current'] = int(self.interfaces['BQ27200'].GetPropertyInteger(u'battery.reporting.current'))
    if 'battery.remaining_time' in signals or force:
      percentage = self.get_property('percentage')
      try:
        percentage = values['percentage']
      except KeyError:
        pass
      active, idle = self.get_timeleft(percentage)
      values['timeleft_idle'] = idle
      values['timeleft_active'] = active
    if 'battery.rechargeable.is_discharging' in signals or 'battery.rechargeable.is_charging' in signals or force:
      charging = bool(self.interfaces['BQ27200'].GetPropertyBoolean(u'battery.rechargeable.is_charging'))
      discharging = bool(self.interfaces['BQ27200'].GetPropertyBoolean(u'battery.rechargeable.is_discharging'))
      if charging and not discharging:
        values['charging'] = 'on'
      elif not charging and discharging:
        values['charging'] = 'off'
      else:
        values['charging'] = 'full'
    if values:
      self.changed(values)

  def get_status(self):
    self.handle_battery_status(0, [], True)

  def get_percentage(self, voltage):
    percentage = 0
    if voltage >= 4050:
      percentage = 85 + (voltage - 4050) / 12.0
    elif voltage >= 3900:
      percentage = 70 + (voltage - 3900) / 10.0
    elif voltage >= 3800:
      percentage = 50 + (voltage - 3800) / 5.0
    elif percentage >= 3660:
      percentage = 15 + (voltage - 3660) / 4.0
    elif voltage >= 3600:
      percentage =  5 + (voltage - 3600) / 6.0
    else:
      percentage = (voltage - 3300) / 60.0
    return get_formatted_percentage(percentage, 100.0)

  def get_timeleft(self, percentage):
    return int(self.interfaces['BQ27200'].GetPropertyInteger(u'battery.remaining_time')), 0
