'''
Advanced Power Battery Wraper BME
2009-2011(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

from advpowcommon.util.execn import *
from advpowcommon.util.format import *
from wrappers.battery.AbstractBattery import AbstractBattery

class BatteryBME(AbstractBattery):

  bme_path = '/org/freedesktop/Hal/devices/bme'
  bme_iface = 'org.freedesktop.Hal.Device'
  bme_signal_path = '/com/nokia/bme/signal'
  bme_signal_iface = 'com.nokia.bme.signal'

  def pre_init(self):
    self.depends['packages'] = {'hald-addon-bme': '0.0.4'}
    self.interfaces_map = {'BME': ('org.freedesktop.Hal', self.bme_path, self.bme_iface)}

  def get_default_dbus_signals(self):
    return {'charger_is_connected': {'source': (self.bme_signal_path, self.bme_signal_iface, 'charger_charging_on')},
            'charger_is_disconnected': {'source': (self.bme_signal_path, self.bme_signal_iface, 'charger_disconnected')},
            'is_full': {'source': (self.bme_signal_path, self.bme_signal_iface, 'battery_full')},
            'status': {'source': (self.bme_path, self.bme_iface, 'PropertyModified')},
           }

  def get_friendly_name(self):
    return 'Nokia\'s BME'

  def post_init(self):
    self.changed({'design': int(self.interfaces['BME'].GetPropertyInteger(u'battery.reporting.design'))})
    self.timeleft_idle_const = self.get_property('design')*600
    #self.get_status()
    self.handle_battery_status(0, [], True)

  def handle_battery_status(self, value, props, force=False):
    signals = [str(x[0]) for x in props]
    values = {}
    if 'battery.voltage.current' in signals or force:
      values['voltage'] = int(self.interfaces['BME'].GetPropertyInteger(u'battery.voltage.current'))
    if 'battery.reporting.current' in signals or force:
      values['current'] = int(self.interfaces['BME'].GetPropertyInteger(u'battery.reporting.current'))
      values['percentage'] = self.get_percentage(values['current'])
      if not 'battery.remaining_time' in signals:
        signals.append('battery.remaining_time')
    if 'battery.remaining_time' in signals or force:
      percentage = self.get_property('percentage')
      try:
        percentage = values['percentage']
      except KeyError:
        pass
      active, idle = self.get_timeleft(percentage)
      values['timeleft_idle'] = idle
      values['timeleft_active'] = active
    if values:
      self.changed(values)

  def handle_battery_charger_is_connected(self):
    self.changed({'charging': 'on'})
    self.handle_battery_status(0, [], True)

  def handle_battery_charger_is_disconnected(self):
    self.changed({'charging': 'off'})
    self.handle_battery_status(0, [], True)

  def handle_battery_is_full(self):
    self.changed({'charging': 'full'})
    self.handle_battery_status(0, [], True)

  def get_status(self):
    run_shell_command_async('/usr/bin/dbus-send --system --type=signal /com/nokia/bme/request com.nokia.bme.request.status_info_req')

  def get_percentage(self, current):
    return get_formatted_percentage(current, self.get_property('design'))

  def get_timeleft(self, percentage):
    return int(self.interfaces['BME'].GetPropertyInteger(u'battery.remaining_time')), int((self.timeleft_idle_const * percentage) / 100)
