#!/usr/bin/env python
'''
Advanced Power Monitor Daemon
2010(c) Kirill Plyashkevich <ru.spirit@gmail.ru>
Works as daemon creating Advanced Power Monitor.
'''
import gobject, signal
import AdvancedPowerMonitor

class apmd():
  def __init__(self):
    self.loop = gobject.MainLoop()
    signal.signal(signal.SIGTERM, self.loop.quit)

  def run(self):
    self.apm = AdvancedPowerMonitor.apm()
    try:
      self.loop.run()
    except (KeyboardInterrupt, SystemExit):
      self.quit()
      raise

  def quit(self, *args):
    self.loop.quit()
    self.apm._cleanup()
    self.apm = None

if __name__ == "__main__":
  daemon = apmd()
  daemon.run()
