'''
Advanced Power Battery Wraper BME
2009-2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

from advpowcommon.util.execn import *
from advpowcommon.util.format import *
from wrappers.battery.AbstractBattery import AbstractBattery

class BatteryBME(AbstractBattery):

  def pre_init(self):
    self.friendly_name = 'Nokia\'s BME'
    self.depends['packages'] = {'hald-addon-bme': '0.0.4'}
    self.interfaces_map = {'BME': ('org.freedesktop.Hal', '/org/freedesktop/Hal/devices/bme', 'org.freedesktop.Hal.Device')}
    self.export_signals = {'battery_charger_is_connected': {'path': '/com/nokia/bme/signal', 'dbus_interface': 'com.nokia.bme.signal', 'signal_name': 'charger_charging_on'},
                           'battery_charger_is_disconnected': {'path': '/com/nokia/bme/signal', 'dbus_interface': 'com.nokia.bme.signal', 'signal_name': 'charger_disconnected'},
                           'battery_is_full': {'path': '/com/nokia/bme/signal', 'dbus_interface': 'com.nokia.bme.signal', 'signal_name': 'battery_full'},
                           'battery_percentage': {'path': '/org/freedesktop/Hal/devices/bme', 'dbus_interface': 'org.freedesktop.Hal.Device', 'signal_name': 'PropertyModified'},
                           'battery_timeleft_info': {'path': '/org/freedesktop/Hal/devices/bme', 'dbus_interface': 'org.freedesktop.Hal.Device', 'signal_name': 'PropertyModified'}
                          }

  def post_init(self):
    self.battery_design = self.interfaces['BME'].GetPropertyInteger(u'battery.reporting.design')
    self.timeleft_idle_const = self.battery_design*600
    self.get_status()
    self.update_percent()
    self.update_timeleft()

#Object path: /org/freedesktop/Hal/devices/bme
#Interface: org.freedesktop.Hal.Device
#Signal: PropertyModified
  def get_percent(self, value, props):
    signals = [str(x[0]) for x in props]
    if 'battery.reporting.current' in signals:
      self.update_percent()
      self.update_timeleft()
    return self.battery_percent

  def update_percent(self):
    self.battery_percent = get_formatted_percentage(self.interfaces['BME'].GetPropertyInteger(u'battery.reporting.current'), self.battery_design)
    return self.battery_percent

  def get_status(self):
    run_shell_command_async('/usr/bin/dbus-send --system --type=signal /com/nokia/bme/request com.nokia.bme.request.status_info_req')

  def get_timeleft(self, value, props):
    signals = [str(x[0]) for x in props]
    if 'battery.remaining_time' in signals:
      self.update_timeleft()
    return [self.timeleft_idle, self.timeleft_active]

  def update_timeleft(self):
    try:
      self.timeleft_active = int(self.interfaces['BME'].GetPropertyInteger(u'battery.remaining_time'))
    except:
      pass
    self.timeleft_idle = int((self.timeleft_idle_const * self.battery_percent) / 100)
    return [self.timeleft_idle, self.timeleft_active]
