'''
Advanced Power Device Mode Wraper MCE
2009-2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

from wrappers.device_mode.AbstractDeviceMode import AbstractDeviceMode

class DeviceModeMCE(AbstractDeviceMode):

  def pre_init(self):
    self.friendly_name = 'Nokia\'s MCE'
    self.dep_packages = {'mce': '1.7.23'}
    self.interfaces_map = {'MCE': ('com.nokia.mce', '/com/nokia/mce/request', 'com.nokia.mce.request')}
    self.export_signals = {'device_mode': {'path': '/com/nokia/mce/signal', 'dbus_interface': 'com.nokia.mce.signal', 'signal_name': 'sig_device_mode_ind'},
                           'system_inactive': {'path': '/com/nokia/mce/signal', 'dbus_interface': 'com.nokia.mce.signal', 'signal_name': 'system_inactivity_ind'}
                          }

  def get_status(self):
    self.device_mode = self.interfaces['MCE'].get_device_mode()
    self.system_inactive = False

  def device_mode_handler(self, mode):
    self.device_mode = str(mode)

  def get_device_mode(self):
    return self.device_mode

  def set_device_mode(self, mode):
    self.interfaces['MCE'].req_device_mode_change(mode)
    self.device_mode = mode

  def system_inactive_handler(self, mode):
    self.system_inactive = bool(mode)

  def get_system_inactive(self):
    return self.system_inactive

  def set_system_inactive(self, mode):
    self.system_inactive = mode

  def tklock(self):
    self.interfaces['MCE'].req_tklock_mode_change("locked")

  def reboot(self):
    self.interfaces['MCE'].req_reboot()

  def shutdown(self):
    self.interfaces['MCE'].req_shutdown()
