'''
Advanced Power Device Mode Wraper Powerlaunch
2009(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

from wrappers.device_mode.AbstractDeviceMode import AbstractDeviceMode

class DeviceModePowerlaunch(AbstractDeviceMode):

  def pre_init(self):
    self.friendly_name = 'Powerlaunch'
    self.dep_packages = {'powerlaunch': '0.9'}
    self.interfaces_map = {'Powered': ('com.nokia.mce', '/org/maemo/Powered', 'org.maemo.Powered')}
    self.export_signals = {'device_mode': {'path': '/com/nokia/mce/signal', 'dbus_interface': 'com.nokia.mce.signal', 'signal_name': 'sig_device_mode_ind'},
                           'system_inactive': {'path': '/com/nokia/mce/signal', 'dbus_interface': 'com.nokia.mce.signal', 'signal_name': 'system_inactivity_ind'}
                          }

  def get_status(self):
    self.device_mode = self.interfaces['Powered'].GetDeviceMode()

  def device_mode_handler(self, mode):
    self.device_mode = mode

  def get_device_mode(self):
    return self.device_mode

  def set_device_mode(self, mode):
    self.interfaces['Powered'].SetDeviceMode(mode)

  def system_inactive_handler(self, mode):
    self.system_inactive = mode

  def get_system_inactive(self):
    return self.system_inactive

  def set_system_inactive(self, mode):
    self.system_inactive = mode

  def tklock(self):
    self.interfaces['Powered'].LockKeys()
    self.interfaces['Powered'].LockScreen()
    self.interfaces['Powered'].DisplayOff()

  def reboot(self):
    self.interfaces['Powered'].Reboot()

  def shutdown(self):
    self.interfaces['Powered'].Shutdown()
