'''
Advanced Power Abstract Battery Wrapper
2008-2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

from wrappers.AbstractWrappers import AbstractWrapper

class AbstractBattery(AbstractWrapper):

  def __init__(self, bus, check = False):
    self.battery_current = 0
    self.battery_design = 1
    self.battery_percent = 0
    self.timeleft_active = -1
    self.timeleft_idle = -1
    AbstractWrapper.__init__(self, bus, check)

  def get_percent(self, *args):
    raise NotImplementedError("AbstractBattery.get_percent(*args) must be implemented")

  def get_timeleft(self, *args):
    raise NotImplementedError("AbstractBattery.get_timeleft(*args) must be implemented")

  def update_percent(self):
    raise NotImplementedError("AbstractBattery.update_percent() must be implemented")

  def update_timeleft(self):
    raise NotImplementedError("AbstractBattery.update_timeleft() must be implemented")
