'''
Advanced Power Battery Wraper BME Free
2009(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

from wrappers.battery.AbstractBattery import AbstractBattery

class BatteryBMEFree(AbstractBattery):

  def pre_init(self):
    self.friendly_name = 'BME Free'
    self.dep_packages = {'bme-free': '0.1.1'}
    self.interfaces_map = {'BMEFree': ('ru.spirit.bme_free', '/ru/spirit/bme_free', 'ru.spirit.bme_free.request')}
    self.export_signals = {'battery_charger_is_connected': {'path': '/ru/spirit/bme_free', 'dbus_interface': 'ru.spirit.bme_free.signal', 'signal_name': 'charger_connected'},
                           'battery_charger_is_disconnected': {'path': '/ru/spirit/bme_free', 'dbus_interface': 'ru.spirit.bme_free.signal', 'signal_name': 'charger_disconnected'},
                           'battery_is_full': {'path': '/ru/spirit/bme_free', 'dbus_interface': 'ru.spirit.bme_free.signal', 'signal_name': 'battery_full'},
                           'battery_percentage': {'path': '/ru/spirit/bme_free', 'dbus_interface': 'ru.spirit.bme_free.signal', 'signal_name': 'battery_percentage_current'}
                          }

  def post_init(self):
    self.update_percent()
    self.update_timeleft()

  def get_percent(self, percent):
    self.battery_percent = percent
    return percent

  def update_percent(self):
    self.battery_percent = self.interfaces['BMEFree'].get_battery_percentage()
    return self.battery_percent

  def get_status(self):
    self.interfaces['BMEFree'].get_state()

  def get_timeleft(self):
    return [self.timeleft_idle, self.timeleft_active]

  def update_timeleft(self):
    return [self.timeleft_idle, self.timeleft_active]
