#!/usr/bin/env python
'''
Advanced Power Monitor Daemon
2009(c) Kirill Plyashkevich <ru.spirit@gmail.ru>
Works as daemon extending AbstractDaemon and creating Advanced Power Monitor.
'''
import sys, gobject, signal
from advpowcommon.util.daemon import AbstractDaemon
import AdvancedPowerMonitor

class apmd(AbstractDaemon):
  def __init__(self):
    AbstractDaemon.__init__(self, '/tmp/apmonitord.pid')
    self.loop = gobject.MainLoop()
    signal.signal(signal.SIGTERM, self.loop.quit)

  def run(self):
    self.apm = AdvancedPowerMonitor.apm()
    self.loop.run()

if __name__ == "__main__":
  daemon = apmd()
  daemon.process_args()
