# -*- coding: utf-8 -*-

'''
Advanced Power Common UI for configuration
2010-2012(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

import gtk, hildon, advpowcommon.ui.ToggleControl

class AbstractNotebook:

  def __init__(self, box=None, items=list()):
    self.classname = self.__class__.__name__
    self.box = box
    self.tabs_height = 0
    self.pages_height = 0
    self.pages = items

  def set_box(self, box):
    self.box = box

  def append_page(self, text, page):
    try:
      self.pages.append([text, self.append(text, page)])
    except:
      pass

  def append(self, text, page):
    raise NotImplementedError('%s.append_page(text, page) must be implemented' % self.classname)

  def append_pages(self, items):
    self.pack_control()
    for page in items:
      self.append_page(page[0], page[1])
    self.set_active(0)

  def pack_control(self):
    raise NotImplementedError('%s.pack_control() must be implemented' % self.classname)

  def set_active(self, ind):
    raise NotImplementedError('%s.set_active(ind) must be implemented' % self.classname)

  def get_area(self):
    raise NotImplementedError('%s.get_area() must be implemented' % self.classname)

  def get_height(self):
    if self.tabs_height < 0:
      return -1
    else:
      return self.tabs_height + self.pages_height

  def update_pages_height(self, page):
    self.pages_height = max(self.pages_height, self.get_box_height(page))

  def get_box_height(self, box):
    children = box.get_children()
    return sum([child.size_request()[1] for child in children])

'''
Maemo 4 UI
'''
class NotebookMaemo4(AbstractNotebook):

  def __init__(self, box=None, items=list()):
    AbstractNotebook.__init__(self, box, items)
    self.__notebook = gtk.Notebook()
    self.__notebook.set_scrollable(True)

  def append(self, text, page):
    area = self.get_area()
    if type(page) != type(area):
      area.add_with_viewport(page)
    else:
      area = page
    self.__notebook.append_page(area, gtk.Label(text))
    self.tabs_height = self.__notebook.get_tab_label(area).size_request()[1]
    self.update_pages_height(page)
    return area

  def pack_control(self):
    self.box.pack_start(self.__notebook)

  def set_active(self, ind):
    self.__notebook.set_current_page(ind)

  def get_area(self):
    sa = gtk.ScrolledWindow()
    sa.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
    return sa

'''
Maemo 5 UI
'''
class NotebookMaemo5(AbstractNotebook):

  def __init__(self, box=None, items=list()):
    AbstractNotebook.__init__(self, box, items)
    self.__toggle_control = advpowcommon.ui.ToggleControl.ToggleControlMaemo5()
    self.__area = gtk.VBox()

  def append(self, text, page):

    def page_toggle(widget, control, page):
      if widget.get_active():
        for cpage in self.pages:
          if cpage[1] == page:
            page.show_all()
          else:
            cpage[1].hide_all()
        #page.show_all()

    area = self.get_area()
    if type(page) != type(area):
      area.add_with_viewport(page)
    else:
      area = page
    self.__toggle_control.add_button(text, page_toggle, area)
    self.__area.pack_start(area, True)
    self.tabs_height = self.__toggle_control.get_box().size_request()[1]
    self.update_pages_height(page)
    self.__area.set_size_request(-1, self.pages_height)
    return area

  def pack_control(self):
    self.box.pack_start(self.__toggle_control.get_box(), False)
    self.box.pack_start(self.__area, True)

  def set_active(self, ind):
    self.__toggle_control.set_active(ind)

  def get_area(self):
    pa = hildon.PannableArea()
    pa.set_property('mov-mode', hildon.MOVEMENT_MODE_BOTH)
#    pa.set_size_request_policy(hildon.SIZE_REQUEST_CHILDREN)
    return pa
