# -*- coding: utf-8 -*-
'''
UI Animation
2010-2012(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

import gobject
from advpowcommon.ui.Cachers import DITPixbufCacher

# DefaultIconThemePixbufCachedAnimator
class DITPBCachedAnimator():

  def __init__(self, images, callback, cacher=None, size=48, time_out=1000):
    self.__images = images
    self.__callback = callback
    if cacher:
      self.__cacher = cacher
    else:
      self.__cacher = DITPixbufCacher(size)
    self.__timeout = time_out
    self.__timer = None
    self.__animating = False
    self.__step = 0
    self.__steps = len(self.__images)

  def animate(self):
    try:
      self.__idle_add_callback()
      self.__step = (self.__step + 1) % self.__steps
    except:
      pass
    return self.__animating

  def start(self):
    if not self.__animating and self.__timer == None:
      self.__animating = True
      self.__timer = gobject.timeout_add(self.__timeout, self.animate)

  def stop(self):
    if self.__animating and self.__timer:
      gobject.source_remove(self.__timer)
      self.__animating = False
      self.__timer = None
      self.__step = 0

  def add_image(self, image):
    try:
      self.__images.index(image)
    except ValueError:
      self.__images.append(image)
      self.__steps = len(self.__images)
    if self.__steps == 1:
      self.__step = 0
      self.__idle_add_callback()
    elif self.__steps > 1:
      self.start()

  def remove_image(self, image):
    try:
      self.__images.remove(image)
      self.__steps = len(self.__images)
      self.__step = 0
      if self.__steps < 2:
        self.stop()
        self.__idle_add_callback(self.__steps == 0)
    except ValueError:
      pass

  def __idle_add_callback(self, empty=False):
    gobject.idle_add(self.__invoke_callback, empty)

  def __invoke_callback(self, empty):
    self.__callback(None if empty else self.__cacher.get(self.__images[self.__step]))
    return False
