
'''
Advanced Power Monitor Utility Library system
2008-2011(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

import re

from advpowcommon.util.common import *

class system:

  installed_packages = {}
  ve = re.compile(r':|\.|-|\+|~')
  vv = re.compile(r'\d+|\D+')

  @staticmethod
  def get_installed_packages(refresh=False):
    if refresh or not system.installed_packages:
      print 'Loading packages list...'
      lines = get_file_lines('/var/lib/dpkg/status')
      packages = {}
      pkey = ''
      installed_ok = False
      #pe = re.compile(r'Package:\s(\S+)')
      ie = re.compile(r'Status:\s.*installed$')
      for x in lines:
        if x.startswith('Package: '):
          #m = pe.match(x)
          #pkey = m.group(1)
          pkey = x.replace('Package: ', '', 1)
          installed_ok = False
        elif x.startswith('Status: ') and ie.match(x):
          installed_ok = True
        elif x.startswith('Version: ') and installed_ok:
          packages[pkey] = system.parse_package_version(x.replace('Version: ', '', 1))
          installed_ok = False
        else:
          continue
      system.installed_packages = packages
    return system.installed_packages

  @staticmethod
  def is_package_installed(package_name):
    if not system.installed_packages:
      system.get_installed_packages()
    return system.installed_packages.has_key(package_name)

  @staticmethod
  def are_packages_installed(packages):
    if not system.installed_packages:
      system.get_installed_packages()
    return set(packages).issubset(set(system.installed_packages.keys()))

  @staticmethod
  def is_package_version_valid(package, version):
    if not system.installed_packages:
      system.get_installed_packages()
    try:
      return cmp(system.installed_packages[package], system.parse_package_version(version)) >= 0
    except:
      return False

  @staticmethod
  def parse_package_version(version):
    return system.parse_version_array(system.ve.split(version))

  @classmethod
  def parse_version_array(self, va):
    result = []
    for v in va:
      if v.isdigit():
        result.append(int(v))
      else:
        m = self.vv.findall(v)
        if m:
          if len(m) == 1:
            result.append(m[0])
          else:
            result.extend(self.parse_version_array(m))
        else:
          result.append(v)
    return result
