# -*- coding: utf-8 -*-

'''
Advanced Power Common UI for configuration
2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

import gtk, hildon
from advpowcommon.ui.ToggleControl import ToggleControlMaemo5

class AbstractNotebook:

  def __init__(self, box=None, items=list()):
    self.classname = self.__class__.__name__
    self.box = box
    self.tabs_height = 0
    self.pages_height = 0
    self.pages = items

  def set_box(self, box):
    self.box = box

  def append_items(self, items):
    self.pages = items
    self.append_pages()

  def append_page(self, text, page):
    raise NotImplementedError('%s.append_page(text, page) must be implemented' % self.classname)

  def append_pages(self):
    raise NotImplementedError('%s.append_pages() must be implemented' % self.classname)

  def set_active(self, ind):
    raise NotImplementedError('%s.set_active(ind) must be implemented' % self.classname)

  def get_area(self):
    raise NotImplementedError('%s.get_area() must be implemented' % self.classname)

  def get_height(self):
    if self.tabs_height<0:
      return -1
    else:
      return self.tabs_height + self.pages_height

  def update_pages_height(self, page):
    self.pages_height = max(self.pages_height, self.get_box_height(page))

  def get_box_height(self, box):
    children = box.get_children()
    height = 0
    for child in children:
      height += child.size_request()[1]
    return height

'''
Maemo 4 UI
'''
class NotebookMaemo4(AbstractNotebook):

  def __init__(self, box=None, items=list()):
    AbstractNotebook.__init__(self, box, items)
    self.__notebook = gtk.Notebook()
    self.__notebook.set_scrollable(True)

  def append_page(self, text, page):
    area = self.get_area()
    if type(page) != type(area):
      area.add_with_viewport(page)
    else:
      area = page
    self.__notebook.append_page(area, gtk.Label(text))
    self.tabs_height = self.__notebook.get_tab_label(area).size_request()[1]
    self.update_pages_height(page)
    
  def append_pages(self):
    self.box.pack_start(self.__notebook)
    for page in self.pages:
      self.append_page(page[0], page[1])

  def set_active(self, ind):
    self.__notebook.set_current_page(ind)

  def get_area(self):
    sa = gtk.ScrolledWindow()
    sa.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
    return sa

'''
Maemo 5 UI
'''
class NotebookMaemo5(AbstractNotebook):

  def __init__(self, box=None, items=list()):
    AbstractNotebook.__init__(self, box, items)
    self.__toggle_control = ToggleControlMaemo5()

  def append_page(self, text, page):

    def page_toggle(widget, page):
      if widget.get_active():
        pages = self.box.get_children()
        for cpage in self.box:
          cpage.hide_all()
        self.__toggle_control.get_box().show_all()
        page.show_all()

    area = self.get_area()
    if type(page) != type(area):
      area.add_with_viewport(page)
    else:
      area = page
    self.__toggle_control.add_button(text, page_toggle, area)
    self.box.pack_start(area)
    self.tabs_height = self.__toggle_control.get_box().size_request()[1]
    self.update_pages_height(page)

  def append_pages(self):
    self.box.pack_start(self.__toggle_control.get_box(), False)
    for page in self.pages:
      self.append_page(page[0], page[1])

  def set_active(self, ind):
    self.__toggle_control.set_active(ind)

  def get_area(self):
    return hildon.PannableArea()
