# -*- coding: utf-8 -*-
'''
Advanced Power Common Locale
2008-2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

import gettext
from advpowcommon.util.singleton import Singleton

class Locale(Singleton):

  def __init__(self):
    Singleton.__init__(self)
    self.__current = {}
    self.initialize()
    gettext.textdomain(self.text_domain)
    self.__gt = gettext.gettext
    for key in self.current_dict:
      self.__current[key] = self.__gt(self.current_dict[key])

  def initialize(self):
    raise NotImplementedError('Locale.initialize() must be implemented')

  def get(self, key):
    try:
      return self.__current[key]
    except KeyError:
      return key

  def get_text(self, text):
    return self.__gt(text)

  def get_item(self, key):
    return self.get('item-%s' % key)
