
'''
Advanced Power Monitor Utility Library Loader
2008-2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

from advpowcommon.util.common import *

import os, os.path, sys

class ClassLoader():
  file_extensions = ('.py', '.pyc', '.pyo')
  ignored_filenames = ('__init__.py', '__init__.pyc', '__init__.pyo')
  ignored_startswith = ('Abstract', '.')

  @staticmethod
  def import_module(name):
    try:
      return sys.modules[name]
    except KeyError:
      pass
    except Exception, e:
      print_exception_message('%s.ClassLoader.import_module(\'%s\')' % (__name__, name), e)
    mod = None
    try:
      mod = __import__(name)
      components = name.split('.')[1:]
      for comp in components:
        mod = getattr(mod, comp)
    except ImportError, e:
      print_exception_message('%s.ClassLoader.import_module(\'%s\')' % (__name__, name), e)
    except ValueError, e:
      print_exception_message('%s.ClassLoader.import_module(\'%s\')' % (__name__, name), e)
    return mod

  @staticmethod
  def import_modules(modules):
    modules_list = set()
    try:
      c_iter = iter(modules)
      while c_iter:
        modules_list.add(ClassLoader.import_module(c_iter.next()))
    except StopIteration:
      pass
    except Exception, e:
      print_exception_message('%s.ClassLoader.import_modules(%s)' % (__name__, modules), e)
    return modules_list

  @staticmethod
  def get_module_class(module):
    if module:
      classname = module.__name__.split('.')[-1]
      return ClassLoader.get_class_object(module, classname)
    else:
      return None

  @staticmethod
  def has_module_class(module):
    class_object = None
    try:
      class_object = module.__dict__[classname]
    except KeyError, e:
      print_exception_message('%s.ClassLoader.has_class_object(\'%s\', \'%s\')' % (__name__, module, classname), e)
    return class_object != None

  @staticmethod
  def get_class_object(module, classname):
    class_object = None
    try:
      class_object = module.__dict__[classname]
    except KeyError, e:
      print_exception_message('%s.ClassLoader.get_class_object(\'%s\', \'%s\')' % (__name__, module, classname), e)
    return class_object

  @staticmethod
  def get_modules_list(root, path):
    cdir = os.path.join(root, path)
    cdirs = os.listdir(cdir)
    dirs = [f for f in cdirs if os.path.isdir(os.path.join(cdir, f)) and not cdir.startswith('.')]
    modules_list = dict()

    def check_path(arg, dirname, files):
      cmodule = dirname.replace(root, '').replace(os.sep, '.')
      try:
        cmodule.index('..')
        return
      except ValueError:
        pass
      if cmodule.startswith('.'):
        cmodule = cmodule[1:]
      modules_list[cmodule] = set()
      files = [f for f in files if os.path.isfile(os.path.join(dirname, f)) and not f in ClassLoader.ignored_filenames and not f.startswith(ClassLoader.ignored_startswith) and f.endswith(ClassLoader.file_extensions)]
      for f in files:
        submodule = f.rsplit('.')[0]
        modules_list[cmodule].add('%s.%s' % (cmodule, submodule))

    os.path.walk(cdir, check_path, '')
    return modules_list
