# -*- coding: utf-8 -*-
'''
2008-2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''
 
def get_formatted_time(s_time, format=0):

  def print_format(value, add_zero=True):
    if add_zero and value < 10:
      return '0%s' % value
    else:
      return '%s' % value

  tmp = ''
  if s_time >= pow(60, 3):
    s_time %= pow(60, 3)
  a_time = []
  for i in range(0,3):
    c_time = s_time%60
    s_time = s_time - c_time
    a_time.append(c_time)
    s_time /= 60
  a_time.reverse()
  a_time = a_time[0:(len(a_time)-format)]
  if a_time[0] == 0:
    tmp = '%s:%s' % (a_time[len(a_time)-2], print_format(a_time[len(a_time)-1]))
  else:
    tmp = '%s' % a_time[0]
    for c_time in a_time[1:]:
      tmp = '%s:%s' % (tmp, print_format(c_time))
  return tmp

def get_formatted_filesize(value, precision=1, size_postfix=['KB', 'MB', 'GB', 'TB']):
  result = value
  size_str = range(len(size_postfix) - 1, -1, -1)
  for x in size_str:
    edge = pow(1024.0, x)
    if (value >= edge):
      tmp = str(round(value / edge, precision))
      if tmp.endswith('.0'): tmp = tmp.rsplit('.')[0]
      result = '%s%s' % (tmp, size_postfix[x])
  return result

def get_formatted_percentage(a, b, precision=1):
  return min(100.0, round(100.0 * a / b, precision))
