# -*- coding: utf-8 -*-
import gobject

from advpowcommon.util.execn import *
from advifswlib.interfaces.Abstract import AbstractInterface

class GSMInterface(AbstractInterface):

  phone_iface = 'com.nokia.phone.net'
  phone_path = '/com/nokia/phone/net'
  phone_iiface = 'Phone.Net'
  cellular_system_signal = 'cellular_system_state_change'
  radio_access_signal = 'radio_access_technology_change'
  strength_signal = 'signal_strength_change'


  gsm_module_iface = 'com.nokia.phone.SSC'
  gsm_module_path = '/com/nokia/phone/SSC'
  gsm_module_signal = 'modem_state_changed_ind'

  def pre_init(self):
    self.state = {
    'name': 'GSM',
    'dbus': {
      'on': {'name': self.cellular_system_signal, 'iface': self.phone_iiface, 'path': self.phone_path, 'args': {}},
      'connected': {'name': self.gsm_module_signal, 'iface': self.gsm_module_iface, 'path': self.gsm_module_path, 'args': {}},
      'strength': {'name': self.strength_signal, 'iface': self.phone_iiface, 'path': self.phone_path, 'args': {}}
    },
    'images': ('ifsw_statusarea_cell_off', 'ifsw_statusarea_cell_on', 'ifsw_statusarea_cell_online'),
    'images_st': ('ifsw_statusarea_cell_signal_0', 'ifsw_statusarea_cell_signal_1', 'ifsw_statusarea_cell_signal_2', 'ifsw_statusarea_cell_signal_3', 'ifsw_statusarea_cell_signal_4', 'ifsw_statusarea_cell_signal_5'),
    'text': ('Off', 'On', '<>'),
    'show': (True, True, False),
    'banner': (True, True, True),
    'value': 0,
    'strength': 0,
    'modes': ('3G+GSM', 'GSM', '3G'),
    'mode': 0
    }
    self.interfaces = {'Phone': [self.phone_iface, self.phone_path, self.phone_iiface, '', False], 'SSC': [self.gsm_module_iface, self.gsm_module_path, self.gsm_module_iface, '', True]}

  def process_signal_on(self, state, arg1, arg2):
    return self.get_status()

  def process_signal_connected(self, value):
    try:
      result = 1 + ['activation_pending', 'online'].index(str(value))
      mode = self.get_mode()
      strength = self.get_strength()
    except:
      result = None
      mode = None
      strength = None
    return result, mode, strength

  def process_signal_strength(self, arg1, arg2):
    return None, None, self.get_strength()

  def get_status(self):
    try:
      status = int(self.get_interface('Phone').get_registration_status()[0])
      result = 0
      if status in (3,4,5,9,10,11):
        result = 1
      elif status in (0,1,2):
        result = 2
      mode = self.get_mode()
      strength = self.get_strength()
    except Exception, e:
      print e
      result = 0
      mode = 0
      strength = 0
    return result, mode, strength

  def turn_on(self):
    gobject.idle_add(self.run_commands, True)

  def turn_off(self):
    gobject.idle_add(self.run_commands, False)

  def turn_mode(self, mode):
    gobject.idle_add(self.run_mode_commands, mode)

  def run_commands(self, flag):
    self.get_interface('SSC').set_radio(flag)
    self.switched()

  def run_mode_commands(self, mode):
    #Thank you, Nokia for
    #dbus.exceptions.DBusException: rpc.Error: can't find method Phone.Net::set_selected_radio_access_technology
    #It's not possible to use
    #self.get_interface('Phone').set_selected_radio_access_technology(mode)
    #but shell is all of sudden working
    run_shell_command('dbus-send --system --type=method_call --dest=%s %s %s.set_selected_radio_access_technology byte:%s' % (self.phone_iface, self.phone_path, self.phone_iiface, mode))
    self.switched()

  def get_mode(self):
    return int(self.get_interface('Phone').get_selected_radio_access_technology()[0])

  def get_strength(self):
    arg1, arg2, arg3 = self.get_interface('Phone').get_signal_strength()
    strength = 0
    if float(arg2) > 0:
      strength = int(round(min(1.0, float(arg1)/float(arg2))*5))
    return strength
