#!/bin/sh
KERNEL_NAME="`uname -r`"
KERNEL_PATH="`/usr/bin/advifsw/get_wlan_path.sh`"
if [ -d $KERNEL_PATH ] ; then
  /usr/bin/advifsw/wlan_unload.sh
  # Get mac address
  MACADDR="`cat /tmp/mac-address`"
  # Load bleeding-edge wl1251
  case "$KERNEL_NAME" in
    2.6.28.10-power50)
      insmod $KERNEL_PATH/compat/compat.ko
      insmod $KERNEL_PATH/net/rfkill/rfkill_backport.ko
      insmod $KERNEL_PATH/net/wireless/cfg80211.ko
      insmod $KERNEL_PATH/net/mac80211/mac80211.ko
      insmod $KERNEL_PATH/drivers/net/wireless/wl1251/wl1251.ko
      insmod $KERNEL_PATH/drivers/net/wireless/wl1251/wl1251_spi.ko
    ;;
    *)
      insmod $KERNEL_PATH/compat.ko
      insmod $KERNEL_PATH/rfkill_backport.ko
      insmod $KERNEL_PATH/cfg80211.ko
      insmod $KERNEL_PATH/mac80211.ko
      insmod $KERNEL_PATH/wl1251.ko
      insmod $KERNEL_PATH/wl1251_spi.ko
    ;;
  esac
  # Restore mac address
  ifconfig wlan0 down hw ether "$MACADDR"
  sleep 1
  /usr/bin/advifsw/exec.sh ./post-load1
else
  echo "$KERNEL_PATH: No such directory"
fi