# -*- coding: utf-8 -*-

'''
Advanced Interface Switcher
2010-2012(c) Kirill Plyashkevich <ru.spirit@gmail.com>
Bluetooth interface object
'''


import dbus, gobject
from advifswlib.interfaces.Abstract import InterfaceState, AbstractInterface
from advpowcommon.util.execn import *

class BTInterface(AbstractInterface):
  def pre_init(self):
    self.interfaces = {'BlueZAdapter': ['org.bluez',
                                        get_shell_command_output('dbus-send --system --dest=org.bluez --print-reply / org.bluez.Manager.DefaultAdapter | tail -1 | sed \'s/^.*"\\(.*\\)".*$/\\1/\' 2>/dev/null').replace('\n', ''),
                                        'org.bluez.Adapter',
                                        None,
                                        True],
                        'BlueZDevice': ['org.bluez',
                                        None,
                                        'org.bluez.Device',
                                        None,
                                        True]}
    self.state = {'name': 'Bluetooth',
                  'dbus': {'on': {'name': 'PropertyChanged',
                                  'iface': self.interfaces['BlueZAdapter'][2],
                                  'path': self.interfaces['BlueZAdapter'][1],
                                  'args': {}},
                           'connected': {'name': 'PropertyChanged',
                                         'iface': self.interfaces['BlueZDevice'][2],
                                         'path': self.interfaces['BlueZDevice'][1],
                                         'args': {'path_keyword': 'path'}}
                          },
                  'images': ('ifsw_statusarea_bluetooth_off', 
                             'ifsw_statusarea_bluetooth_on', 
                             'ifsw_statusarea_bluetooth_online'),
                  'images_st': ('ifsw_statusarea_bluetooth_online'),
                  'text': ('Off', 'On', '<>'),
                  'show': (False, True, True),
                  'banner': (True, True, True),
                  'value': InterfaceState.off,
                  'strength': 0,
                  'modes': ('bluetooth-connectable', 'bluetooth-discoverable'),
                  'mode': 0}
    self.connected_device = set()

  def process_signal_connected(self, prop, value, **kwargs):
    if str(prop) == 'Connected':
      device = kwargs['path'].replace('%s/' % self.interfaces['BlueZAdapter'][1], '')
      if value:
        self.connected_device.add(device)
        return InterfaceState.connected, None, None
      else:
        try:
          self.connected_device.remove(device)
        except KeyError:
          pass
        if len(self.connected_device) == 0:
          return self.get_status()
    else:
      return None, None, None

  def process_signal_on(self, prop, value, **kwargs):
    prop = str(prop)
    if (prop == 'Powered'):
      return InterfaceState.on if int(value) else InterfaceState.off,\
             None,\
             None
    elif (prop == 'Discoverable'):
      return None, int(value), None
    else:
      return None, None, None

  def get_status(self):
    props = self.get_interface('BlueZAdapter').GetProperties()
    discoverable = int(props['Discoverable'])
    return InterfaceState.on if int(props['Powered']) else InterfaceState.off,\
           discoverable,\
           0

  def turn_on(self):
    gobject.idle_add(self.run_commands, True)

  def turn_off(self):
    for device in self.connected_device:
      try:
        conndev_iface = dbus.Interface(self.get_bus()\
                                       .get_object(self.interfaces['BlueZDevice'][0],
                                                   '%s/%s' %
                                                   (self.interfaces['BlueZAdapter'][1],
                                                    device),
                                                   introspect=True),
                                       self.interfaces['BlueZDevice'][2])
        conndev_iface.Disconnect()
      except:
        pass
    gobject.idle_add(self.run_commands, False)

  def turn_mode(self, mode, startup):
    gobject.idle_add(self.run_mode_commands, mode)

  def run_commands(self, flag):
    self.get_interface('BlueZAdapter').SetProperty('Powered', flag)
    self.switched()

  def run_mode_commands(self, visible):
    self.get_interface('BlueZAdapter').SetProperty('Discoverable', 
                                                   bool(visible))
    self.switched()
