#
# Copyright 2011 Ruediger Gad <r.c.g@gmx.de>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

import gobject

#from gtkpixbuftextwriter import GtkPixbufTextWriter

class PixbufAnimationPlayer():
    def __init__(self, pixbuf_animation, x, y, scaling, parent):
        self.iter = pixbuf_animation.get_iter()
        self.x = x
        self.y = y
        self.scaling = scaling
        self.parent = parent

        self.parent.draw_pixbuf(self.iter.get_pixbuf(), self.x, self.y, self.scaling)

        delay = self.iter.get_delay_time()
        if delay > 0 :
            gobject.timeout_add(delay, self.animation_cb)

    def animation_cb(self):
        self.iter.advance()
        self.parent.draw_pixbuf(self.iter.get_pixbuf(), self.x, self.y, self.scaling)
        
        delay = self.iter.get_delay_time()
        if delay > 0 :
            gobject.timeout_add(delay, self.animation_cb)

        return False

