/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : main.cpp
 Author      : Joost Kop
 Version     : 0.1
 Description : CPP main
 ============================================================================
 */
#include <stdlib.h>
#include <sys/types.h>
#include "config.h"

#include "ActionManagerDaemon.h"
#include "osso_context.h"

bool quit;
osso_context_t *osso_context;
ActionManagerDaemon *pDaemon = NULL;

void CreateOssoContext(void)
{
	osso_context = osso_initialize("ActionManagerDaemon", "0.1", TRUE, 0);
	if(!osso_context)
		g_print("osso_initialize() failed.\n");
}

void CloseOssoContext(void)
{
	osso_deinitialize(osso_context);
}

osso_context_t *GetOssoContext(void)
{
	return osso_context;
}

void startActionManager(void)
{
	ActionManagerDaemon *pDaemon = new ActionManagerDaemon();
	pDaemon->ReadConfiguration();
	//pDaemon->SaveConfiguration();
}

void stopActionManager(void)
{
	if(pDaemon)
		delete pDaemon;
}

void onSignal(int in)
{
	quit = true;
}

void printHelp(void)
{
	// print usage
	printf("usage: \n");
	printf("   actionmanagerdaemon [options]\n");
	printf("options:\n");
	printf("   --help           : \thelp\n");
	printf("   --daemon         : \texecute as daemon\n");
}

int main(int argc, char *argv[])
{

	bool isdaemon=false;
	char* optionName;
	if(argc>1)
	{
		for(int i=1;i<argc;i++)
		{
			optionName=argv[i];
			if(!strcmp(optionName,"--daemon"))
			{
				isdaemon=true;
			}
			else
			{
				printHelp();
				exit(0);
			}
		}
	}

	if(isdaemon)
	{
		pid_t pid, sid;
		/* Fork off the parent process */
		pid = fork();
		if (pid < 0) {
			exit(EXIT_FAILURE);
		}
        /* If we got a good PID, then
           we can exit the parent process. */
		if (pid > 0) {
			exit(EXIT_SUCCESS);
		}
		/* Change the file mode mask */
		//umask(0);
		/* Open any logs here */

        /* Create a new SID for the child process */
        sid = setsid();
        if (sid < 0) {
        	/* Log the failure */
        	exit(EXIT_FAILURE);
        }
        /* Close out the standard file descriptors */
        close(STDIN_FILENO);
        close(STDOUT_FILENO);
        close(STDERR_FILENO);

		signal(SIGTERM, onSignal);
		signal(SIGINT, onSignal);
		signal(SIGKILL, onSignal);
		quit = false;
		startActionManager();
		while (!quit) {
			usleep(100000);
		}
		stopActionManager();
		return(EXIT_SUCCESS);
	}
	else
	{
		signal(SIGTERM, onSignal);
		signal(SIGINT, onSignal);
		signal(SIGKILL, onSignal);
		quit = false;
		startActionManager();

		while (!quit) {
			usleep(100000);
		}
		stopActionManager();
		return(EXIT_SUCCESS);
	}
}
