/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : TriggerContainer.cpp
 Author      : Joost Kop
 Version     : 0.1
 Description :
 ============================================================================
 */

#include "TriggerContainer.h"

/* Class constructor */
TriggerContainer::TriggerContainer()
{
}

/* Class destructor */
TriggerContainer::~TriggerContainer()
{
	/* Delete the triggerItems */
	for(int i=TriggerItems.size(); i>0 ; i--)
	{
		delete TriggerItems[i-1];
	}
}

TriggerList TriggerContainer::GetTriggers(void)
{
	return TriggerItems;
}

void TriggerContainer::SetData(Element *elem)
{
	Node::NodeList list = elem->get_children();
	for(Node::NodeList::iterator iter = list.begin(); iter != list.end(); ++iter)
	{
		Element *cur_node = (Element*)*iter;
		if(cur_node->get_name() == TRIGGER_ELEM_NAME)
		{
			ustring name = cur_node->get_attribute_value("name");
			if(!name.empty())
			{
				Trigger *trig = new Trigger(name);
				trig->SetData(cur_node);
				TriggerItems.push_back(trig);
			}
		}
	}
}

void TriggerContainer::GetData(Element *elem)
{
	/* Save name attribute */
	elem->set_attribute("name", name);
	/* Create childs for all Triggers */
	for(int i=0; i<TriggerItems.size() ; i++)
	{
		Element *cur_node = elem->add_child(TRIGGER_ELEM_NAME);
		TriggerItems[i]->GetData(cur_node);
	}
}
