/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : Trigger.h
 Author      : Joost Kop
 Version     : 0.1
 Description : triggers an action
 ============================================================================
 */

#ifndef TRIGGER_H
#define TRIGGER_H

#include <string>
using namespace std;
#include <libxml++/libxml++.h>
using namespace xmlpp;

#include "Action.h"

#define TRIGGER_ELEM_NAME "trigger"

typedef vector<Action*> ActionList;

class Trigger
{
private:
	string name;
	ActionList Actions;

public:
	Trigger(string name);
	~Trigger();

	string GetName(void);

	void AddAction(string action, Element *elem=NULL);
	ActionList GetActions(void);

	void ExecuteTrigger(void);

	void SetData(Element *elem);
	void GetData(Element *elem);
};

#endif /* TRIGGER_H */
