/*******************************************************************************
 * Copyright (c) 2007-2008 INdT.
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.

 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 ============================================================================
 Name        : ActionManagerDaemon.h
 Author      : Joost Kop
 Version     : 0.1
 Description :
 ============================================================================
 */

#ifndef ACTIONMANAGERDAEMON_H
#define ACTIONMANAGERDAEMON_H

#include <vector>
using namespace std;

#include "Action.h"
#include "Trigger.h"
#include "TriggerContainer.h"

typedef vector<TriggerContainer*> TriggerContainerList;

class ActionManagerDaemon
{
private:
	TriggerContainerList ContainerList;

public:
	ActionManagerDaemon();
	~ActionManagerDaemon();

	/* Should be a list of names!*/
	TriggerList GetAllTriggers(void);
	//ActionList GetAllActions(void);

	void SetAction(const char *triggerName, const char *actionName);

	void SaveConfiguration(void);
	void ReadConfiguration(void);
};

#endif /* ACTIONMANAGERDAEMON_H */
