#    Openvpn Applet
#    Copyright (C) 2008  Mikko Vartiainen <mvartiainen@gmail.com>
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

import glob
import os
import string
from subprocess import Popen, PIPE, call
import gtk
import hildondesktop
import hildon
import gobject
import osso
from sets import Set
import fileinput
import re
from UserDict import UserDict

import time

def copy_file(file):
    print "Copy: ", file
    for f in file:
        if f != None:
            print f
            print file[f]
            call(['sudo','/usr/libexec/openvpn-applet-helper.py', 'copy', str(f), str(file[f])])

def delete_files(file):
    print "Delete: ", file
    for f in file:
        if f != None:
            call(['sudo','/usr/libexec/openvpn-applet-helper.py', 'delete', f])
    

def pid_exists(pid):
    try:
        os.kill(pid, 0)
        return True
    except OSError, err:
        if err.errno == 1:
            return True
        else:
            return False
    
def openvpn_running(pid):
    p = Popen("pidof openvpn", shell=True, stdout=PIPE)
    pipe = p.stdout
    s = pipe.read().split()
    p.wait()
    print s
    if s.count(str(pid)):
        return True
    else:
        return False
        
class vpn():
    def __init__(self, conf_file, conf_dir='/etc/openvpn'):
        self.conf_file = conf_file
        self.name = string.split(os.path.basename(self.conf_file),'.')[0]
        self.pid_file = '/var/run/openvpn.'+self.name+'.pid'
        self.conf_dir = conf_dir
        self.stopcmd = '/etc/init.d/openvpn'
        self.startcmd = '/usr/sbin/openvpn'
        self.log_file = '/tmp/'+self.name+'.log'
        parameters = self.__read_conf()
        print parameters
        if parameters["auth-user-pass"] == True:
            self.user_auth = True
        else:
            self.user_auth = False
        
        if parameters["askpass"] == True or parameters["auth-user-pass"] == True:
            self.pass_auth = True      
        else:
            self.pass_auth = False
        
        
    def get_status(self):
        pid = self.get_pid()
                
        if pid != None and pid_exists(pid) and openvpn_running(pid):
            #self.pid = pid
            return 0
        else:
            return -1
        
    def get_pid(self):
        print "pid_file: ",self.pid_file
        try:
            f = open(self.pid_file)
        except IOError:
            return None
        
        pid = int(f.readline())    
        return int(pid)
        
    def start(self,user=None,passwd=None,enable_log=False):
        print "start",user,passwd
        command =["sudo",self.startcmd,"--daemon","--writepid",self.pid_file,"--config",self.conf_file]
        if enable_log:
            command.extend(['--log',self.log_file])
        process = Popen(command, shell=False, stdin=PIPE, stdout=None, cwd=self.conf_dir)
        input = process.stdin
              
        if self.user_required and user != None:
            print >>input,user

        if self.pass_required and passwd != None:
            print >>input,passwd

        input.close()
        
        return process.returncode
        
    def stop(self):
        print "stop"
        #status = call(['sudo', self.cmd, 'stop', self.name, self.conf_dir])
        status = call(['sudo', self.stopcmd, 'stop', self.name])
        return status

    def get_conf_file(self):
        return self.conf_file        

    def get_name(self):
        return self.name

    def user_required(self):
        return self.user_auth
        
    def pass_required(self):
        return self.pass_auth

    def get_log_file(self):
        return self.log_file

    def __read_conf(self):
        parameters = {}
        keywords = ["askpass","auth-user-pass"]
        
        line = None
        for line in fileinput.input(self.conf_file):
            #print "line: ", line
            #check for keywords
            s = line.split()
            if len(s) > 0:
                for word in keywords:
                    #print word
                    if word == s[0]:
                        print "MATCH: ", word
                        #get filename
                        if len(s) > 1:
                            filename = line.split()[1]
                            #check path
                            if os.path.exists(filename):
                                parameters[word] = filename
                            elif os.path.exists(os.path.join(self.conf_dir, filename)):
                                parameters[word] = filename
                            else:
                                parameters[word] = None
                        else:
                            parameters[word] = True
                    else:
                        parameters[word] = False

        if line == None:
            for word in keywords:
                parameters[word] = False

        return parameters
    
class vpn_control():
    def read_vpn_conf(self, dir, ext):
        vpn_conf = []
        for e in ext:
            l = glob.glob(dir+'/*.'+e)
            if len(l) > 0: vpn_conf.extend(l)
        return vpn_conf        
        
    def __init__(self):
        self.vpn_list = []
        for v in self.read_vpn_conf('/etc/openvpn',['conf']):
            print v
            self.vpn_list.append(vpn(v))
        for v in self.read_vpn_conf('/home/user/.openvpn-applet',['conf']):
            print v
            self.vpn_list.append(vpn(v,'/home/user/.openvpn-applet'))
    
    def __str__(self):
        s = ''
        for i,v in enumerate(self.vpn_list):
            if v.get_status() != 0: cmd = 'start'
            else: cmd = 'stop'
            s = s+str(i+1)+'. '+v.name+' - '+cmd+'\n'
        return s   

    def start(self, index,user=None,passwd=None,enable_log=False):
        self.vpn_list[index].start(user,passwd)
        
    def stop(self, index):
        self.vpn_list[index].stop()
        
    def status(self, index):
        if len(self.vpn_list) > 0:
            return self.vpn_list[index].get_status()
        else:
            return -1

    def get_log_file(self,index):
        return self.vpn_list[index].get_log_file()

    def user_required(self,index):
        return self.vpn_list[index].user_required()
        
    def pass_required(self,index):
        return self.vpn_list[index].pass_required()


    
class openvpn_applet(hildondesktop.HomeItem):
    def __init__(self):
        hildondesktop.HomeItem.__init__(self)
       
        self.vc = None
        self.banner = None
        self.timer = None       
        
        self.frame = gtk.Frame()
        self.frame.set_name("osso-speeddial")
        #self.frame.set_border_width(0)
        
        #screen = self.get_screen()
        #colormap = screen.get_rgba_colormap()
        #if colormap == None:
        #    self.frame.set_label("No Alpha")
        #    colormap = screen.get_rgb_colormap()
        #else:
        #    self.frame.set_label("Alpha")
        #self.frame.set_colormap(colormap)
        
        self.hbox = gtk.HBox()
        self.alignment = gtk.Alignment(0.5,0.5,1.0,1.0)
        self.alignment.set_padding(15,15,15,15)
   
        self.button = gtk.Button(label="Start")
        self.button.connect("clicked", self.button_clicked_event)
        self.hbox.pack_start(self.button)
        
        cell = gtk.CellRendererText()
        self.combo = gtk.ComboBox()
        self.combo.pack_start(cell, True)
        self.combo.add_attribute(cell, 'text', 0)

        self.vseparator = gtk.VSeparator()
        self.hbox.pack_start(self.vseparator)

        self.combo.connect("changed", self.combo_changed_event)
        self.hbox.pack_start(self.combo)

        #self.set_resize_type(hildondesktop.HOME_ITEM_RESIZE_BOTH)
        self.connect("settings", self.settings_event)
        self.frame.add(self.alignment)
        self.alignment.add(self.hbox)
        self.add(self.frame)

        self.update_list()
        self.show_all()
    
    def update_list(self):
        vpn_list = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_BOOLEAN)
        self.vc = vpn_control()
        for i,v in enumerate(self.vc.vpn_list):
            vpn_list.insert(i,(v.get_name(), v.get_conf_file(),True))
            #self.combo.insert_text(i,v.name)
        self.combo.set_model(vpn_list)
        if len(self.vc.vpn_list) > 0:
            self.combo.set_active(0)
        self.frame.check_resize()
    
    def get_vpn_list(self):
        return self.combo.get_model()
        
    def combo_changed_event(self,widget):
        index = self.combo.get_active()
        if index >= 0:
            if self.vc.status(index) != 0:
                self.button.set_label("Start")
            else:
                self.button.set_label("Stop")
    
    def button_clicked_event(self,widget):
        index = self.combo.get_active()
        if index >= 0:
            if self.vc.status(index) != 0:
                if self.vc.user_required(index) and self.vc.pass_required(index):
                    (user,passwd,cont) = self.user_pass_dlg(True)
                elif self.vc.pass_required(index):
                    (user,passwd,cont) = self.user_pass_dlg(False)
                else:
                    user   = None
                    passwd = None
                    cont = True
                if cont:
                    self.banner = hildon.hildon_banner_show_information(self,None,"Starting Openvpn Connection")
                    self.vc.start(index,user,passwd)
            else:
                self.banner = hildon.hildon_banner_show_information(self,None,"Stopping Openvpn Connection")
                self.vc.stop(index)
        self.timeout = 50
        self.timer = gobject.timeout_add(200, self.update_button)

    
    def user_pass_dlg(self,ask_passwd):
        if ask_passwd:
            dlg = hildon.LoginDialog(gtk.Window())
            dlg.set_message("Openvpn Authentication")
            response = dlg.run()
            user_pass_resp = (dlg.get_username(),dlg.get_password())
            dlg.destroy()
        else:
            dlg = hildon.GetPasswordDialog(gtk.Window(),False)
            dlg.set_message("Openvpn Authentication")
            response = dlg.run()
            user_pass_resp = (None,dlg.get_password())
            dlg.destroy()

        if response == gtk.RESPONSE_OK:
            user_pass_resp = (user_pass_resp[0],user_pass_resp[1],True)
        else:
            user_pass_resp = (user_pass_resp[0],user_pass_resp[1],False)

        return user_pass_resp
    
    def update_button(self):
        self.timeout = self.timeout - 1
        index = self.combo.get_active()
        if self.timeout > 0:
            if self.vc.status(index) != 0:
                new_label = "Start"
            else:
                new_label = "Stop"
            
            if self.button.get_label() != new_label:
                self.button.set_label(new_label)
                self.timeout = 0
                self.timer = None
            else:
                self.timer = gobject.timeout_add(200, self.update_button)

    def settings_event(self, widget, data=None):
        widget = gtk.MenuItem("Openvpn setup")
        widget.connect("activate", self.open_settings)
        return widget
        
    def open_settings(self, widget, data=None):
        dlg = OpenvpnAppletSettings(model=self.combo.get_model(), applet=self)
        dlg.run()
        dlg.destroy()
        

class OpenvpnAppletSettings(gtk.Dialog):
    def __init__(self,title="Openvpn connections", parent=None, flags=0, buttons=None, model=None, applet=None):
        gtk.Dialog.__init__(self,title, parent, flags, buttons)
        
        self.mode = model
        self.applet = applet
        
        self.treeview = gtk.TreeView(model)
        self.vpncolumn = gtk.TreeViewColumn('Openvpn Connection')
        self.treeview.append_column(self.vpncolumn)
        self.cell = gtk.CellRendererText()
        self.vpncolumn.pack_start(self.cell, True)
        self.vpncolumn.add_attribute(self.cell, 'text', 0)

        self.new_button = gtk.Button("New")
        self.new_button.connect("clicked", self.open_new_dialog)
        self.delete_button = gtk.Button("Delete")
        self.delete_button.connect("clicked", self.delete_clicked_event)
        #self.disable_button = gtk.Button("Disable")
        #self.disable_button.connect("clicked", self.disable_clicked_event)
        #self.test_button = gtk.Button("Disable")
        #self.test_button.connect("clicked", self.test_clicked_event)


        self.treeview.set_size_request(-1, 155)
        scrolledwindow = gtk.ScrolledWindow()
        scrolledwindow.set_policy(gtk.POLICY_AUTOMATIC,gtk.POLICY_AUTOMATIC)
        scrolledwindow.add(self.treeview)
        hbox = gtk.HBox()
        hbox.pack_start(scrolledwindow)
        self.vbox.pack_start(hbox)   
        self.action_area.pack_start(self.new_button)
        self.action_area.pack_start(self.delete_button)
        self.add_button("Close", gtk.RESPONSE_CLOSE)
        self.action_area.show_all()
        self.vbox.show_all()
        
        
    def open_new_dialog(self, widget, data=None):
        dlg = OpenvpnAppletNewConnection()
        response = dlg.run()
        if response == gtk.RESPONSE_OK:
            copy_file(dlg.get_filenames())
            self.applet.update_list()
            self.treeview.set_model(self.applet.get_vpn_list())
        dlg.destroy()

    def delete_clicked_event(self, widget, data=None):
        print "delete_clicked_event"
        file_links = FileLinks("/etc/openvpn", ["conf", "ovpn"])
        selection = self.treeview.get_selection()
        selection.set_mode(gtk.SELECTION_SINGLE)
        (model, iter) = selection.get_selected()
        if iter != None:
            print "Item selected"
            filename = model.get_value(iter,1)
            print filename
            print file_links[filename]
            mstr = filename
            for f in file_links[filename]:
                mstr += "\n"+str(f)
            dlg = gtk.MessageDialog(self,0,gtk.MESSAGE_QUESTION,gtk.BUTTONS_NONE,"Deleting files:\n"+mstr)
            dlg.add_buttons("Delete", gtk.RESPONSE_ACCEPT,"Cancel", gtk.RESPONSE_REJECT)
            response = dlg.run()
            dlg.destroy()
            if response == gtk.RESPONSE_ACCEPT:
                delete_files(file_links[filename])
                delete_files([filename])
        else:
            print "No selection"

        self.applet.update_list()
        self.treeview.set_model(self.applet.get_vpn_list())
        
    def disable_clicked_event(self, widget, data=None):
        pass
    
#    def test_clicked_event(self,widget,data=None):
#        if self.applet.vc.user_required(index) and self.applet.vc.pass_required(index):
#            (user,passwd,cont) = self.applet.user_pass_dlg(True)
#        elif self.vc.pass_required(index):
#            (user,passwd,cont) = self.applet.user_pass_dlg(False)
#        else:
#            user   = None
#            passwd = None
#            cont = True
#        if cont:
#            self.vc.start(index,user,passwd,True)
#
#        log_file_fd = os.open(vpn.get_log_file(),os.O_RDONLY)
#        dlg = OpenvpnAppletTestConnection(log_file_fd)
#        dlg.run()        
#        dlg.destroy()
#
#        log_file_fd.close()

#class OpenvpnAppletTestConnection(gtk.Dialog):
#    def __init__(self,title="Test Connection", parent=None, flags=0, buttons=None,log_file_fd=None):
#        gtk.Dialog.__init__(self,title, parent, flags, buttons)
#        
#        self.fd = log_file_fd
#        
#        self.textbuffer = gtk.TextBuffer()
#        self.textview = gtk.TextView(self.textbuffer) 
#        
#        scrolledwindow = gtk.ScrolledWindow()
#        scrolledwindow.set_policy(gtk.POLICY_AUTOMATIC,gtk.POLICY_AUTOMATIC)
#        scrolledwindow.add(self.textview)
#        
#        self.vbox.pack_start(scrolledwindow)
#                
#        button = gtk.Button(Close)
#        self.add_button("Close",gtk.RESPONSE_CLOSE)
#        
#        self.update_text()
#        self.show_all()
#    
#    def update_text(self):
#        self.timer = gobject.timeout_add(1000, self.update_text)
#       text = self.fd.read()
#        self.textbuffer.set_text(text)
        
    
class OpenvpnAppletNewConnection(gtk.Dialog):
    def __init__(self,title="New Connection", parent=None, flags=0, buttons=None):
        gtk.Dialog.__init__(self,title, parent, flags, buttons)

        self.check = []
        self.file_entry = []        

        self.add_button("Import Selected",gtk.RESPONSE_OK)
        self.add_button("Cancel",gtk.RESPONSE_CANCEL)
        #self.filechooser = hildon.FileChooserDialog(self,gtk.FILE_CHOOSER_ACTION_OPEN)

        #file_dialog = hildon.FileChooserDialog(self,gtk.FILE_CHOOSER_ACTION_OPEN)
        descriptions = ["Configuration File:", "Key File:", "Cert File:", "Ca File:","Secret File:", "PKCS12 File:"]
        table = gtk.Table(len(descriptions), 2)
        for i,d in enumerate(descriptions):
            hbox = gtk.HBox()
            self.file_entry.append(gtk.Entry())
            browse_button = gtk.Button("Browse")

            hbox.pack_start(self.file_entry[i])
            hbox.pack_start(browse_button)           
            self.check.append(gtk.CheckButton(d))
            browse_button.connect("clicked", self.browse_button_event, (self.file_entry[i], self.check[i]))   

            table.attach(self.check[i],0,1,i,i+1)
            table.attach(hbox,1,2,i,i+1)   
            self.vbox.pack_start(table)
            
        self.vbox.show_all()

    def get_filenames(self):
        files = {}
        for i,check in enumerate(self.check):
            if check.get_active():
                fname = self.file_entry[i].get_text()
                perm = '600'
                for ext in ["conf", "ovpn"]:
                    if re.search("\."+ext+"$",fname):
                        perm = '644'
                files[self.file_entry[i].get_text()] = perm
        return files
    
    def browse_button_event(self, widget, data=None):
        textentry = data[0]
        checkbox = data[1]
        dlg = hildon.FileChooserDialog(self,gtk.FILE_CHOOSER_ACTION_OPEN)
        response = dlg.run()
        if response == gtk.RESPONSE_OK:
            textentry.set_text(dlg.get_filename())
            checkbox.set_active(True)
        dlg.destroy()
        

class FileLinks(UserDict):
    def __init__(self, directory, filetypes):
        UserDict.__init__(self)
        self.directory = directory
        self.keywords = ["secret","up","down","ca","cert","key","pkcs12","iproute","status","dh","tls-verify","ipchange","client-connect","route-up","client-disconnect","learn-address","auth-user-pass-verify","askpass","auth-user-pass"]
        self.filetypes = filetypes
        self.update()
    
    def update(self):
        print "function: update"
        self.data = {}
        self.references = {}
        for root, dirs, files in os.walk(self.directory):
            print root, files
            for name in files:
                print "name: ", name
                for type in self.filetypes:
                    if re.search(".*\."+type+"$",name):
                        self.data[os.path.join(root, name)] = self.__scan(os.path.join(root, name), root)
                
    def __scan(self,file,root):
        print "function: __scan", file, root
        fileset = Set()
        for line in fileinput.input(file):
            parts = line.split()
            #check for keywords
            if len(parts) > 0:
                for word in self.keywords:
                    if parts[0] == word:
                        print "MATCH: ", word
                        #get filename
                        if len(parts) > 1:
                            filename = parts[1]
                        else:
                            filename = None
                        #check path
                        if filename != None and os.path.exists(filename):
                            #add to return Set
                            fileset.add(filename)
                        elif filename !=None and os.path.exists(os.path.join(root, filename)):
                            fileset.add(os.path.join(root, filename))
                        else:
                            filename = None
                    
        #add entries in return Set to reference count
        for f in list(fileset):
            try:
                self.references[f] += 1
            except KeyError:
                self.references[f]  = 1
        return list(fileset)

    def __getitem__(self,item):
        items = self.data[item]
        return_items = []
        for it in items:
            if self.references[it] == 1:
                return_items.append(it)
        return return_items
     
        
def hd_plugin_get_objects():
	plugin = openvpn_applet()
	return [plugin]


if __name__ == '__main__':
    vc = vpn_control()
    print vc
    sel = int(raw_input("command: "))-1
    if vc.status(sel) != 0:
        vc.start(sel)
    else:
        vc.stop(sel)
