/*
 * Copyright (c) 2006 Frantisek Dufka
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/types.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/nand.h>
#include <linux/mtd/partitions.h>

#define	DRIVER_NAME	"nand_rw_enable"

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Frantisek Dufka <dufkaf@seznam.cz>");
MODULE_DESCRIPTION("Hack to set MTD_CLEAR_BITS in specific partition to enable reflashing (kernel in /dev/mtd2 on Nokia N770)");
MODULE_ALIAS(DRIVER_NAME);

static char *partition = "kernel";
static u_int32_t oldflags;
static int flags_stored=0;

module_param(partition, charp,0);
MODULE_PARM_DESC(partition, "mtd partition name");

extern struct semaphore mtd_table_mutex;
extern struct mtd_info *mtd_table[];

static int __init nand_rw_enable_init(void)
{
	int i;
	//printk(DRIVER_NAME": searching for %s partition ...\n",partition);
        for (i=0; i<MAX_MTD_DEVICES; i++) {
		if (mtd_table[i] && mtd_table[i]->type != MTD_ABSENT){
			//printk("name %s flags %08x\n",mtd_table[i]->name,mtd_table[i]->flags);
			if (strcmp(mtd_table[i]->name,partition)==0){
				if ((mtd_table[i]->flags&MTD_CLEAR_BITS) == 0){
					oldflags=mtd_table[i]->flags;
					flags_stored=1;
					mtd_table[i]->flags|=MTD_CLEAR_BITS;
					printk(DRIVER_NAME": added MTD_CLEAR_BITS to \"%s\" flags, partition is writable now\n",partition);
					break;
				}
			}
		}
		
	}		
	if (!flags_stored)
		printk(DRIVER_NAME": nothing done, partition \"%s\" not found or was already writable\n",partition);
	return 0;
}

static void __exit nand_rw_enable_exit(void)
{
	int i;
	if (!flags_stored) return; // nothing to do
        for (i=0; i<MAX_MTD_DEVICES; i++) {
		if (mtd_table[i] && mtd_table[i]->type != MTD_ABSENT){
			//printk("name %s flags %08x\n",mtd_table[i]->name,mtd_table[i]->flags);
			if (strcmp(mtd_table[i]->name,partition)==0){
				mtd_table[i]->flags=oldflags;
				printk(DRIVER_NAME": flags restored for \"%s\" partition\n",partition);
			}
		}
		
	}		

}

module_init(nand_rw_enable_init);
module_exit(nand_rw_enable_exit);

